<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'education_accounts_and_online_classrooms') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item position-relative">
                    <div class="faq-target" id="education-accounts"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingEight">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseEight" aria-expanded="true" aria-controls="faqCategories-accordion-collapseEight">
                            {{ getJsonLocalization('generalfaq', 'education_accounts_and_online_classrooms') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseEight" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingEight" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="education-account-n-classrooms">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseOne" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'what_are_online_classrooms') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseOne" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingOne" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'online_classrooms_description') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'teach_students_safely') }}</b> {{ getJsonLocalization('generalfaq', 'teach_students_safely_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'monitor_students_during_exams') }}</b> {{ getJsonLocalization('generalfaq', 'monitor_students_during_exams_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'create_online_tests') }}</b> {{ getJsonLocalization('generalfaq', 'create_online_tests_desc') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTwo" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'why_should_school_create_account') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseTwo" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTwo" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'advantages_of_creating_account') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'student_visibility') }}</b> {{ getJsonLocalization('generalfaq', 'student_visibility_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'online_classrooms') }}</b> {{ getJsonLocalization('generalfaq', 'online_classrooms_desc') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseThree" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'how_students_join') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseThree" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingThree" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'how_students_join_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFour" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'how_teachers_join') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseFour" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFour" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'how_teachers_join_desc1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'how_teachers_join_desc2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFive" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'student_without_webcam') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseFive" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFive" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'student_without_webcam_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSix" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'student_with_mobile_device') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseSix" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSix" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'student_with_mobile_device_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSeven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'record_students_screen') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseSeven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSeven" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'record_students_screen_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEight" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'where_to_find_recordings') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseEight" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEight" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'where_to_find_recordings_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseNine" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'participant_screen_share') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseNine" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingNine" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'participant_screen_share_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTen" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'what_is_recorded') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseTen" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTen" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'what_is_recorded_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEleven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'classroom_participant_limit') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseEleven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEleven" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'classroom_participant_limit_desc') }} <a href='/public/fees-and-subscription' class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'price_range_for_plans') }}</a>.</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
