<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_title') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">Frequently asked questions</h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">Here are the most frequently asked questions, organized by themes. We continuously update this page with questions we receive.</h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">Sign Up</a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">Contact</a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section> -->

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="faqCategories-accordion-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseOne" aria-expanded="false true" aria-controls="faqCategories-accordion-collapseOne">
                            {{ getJsonLocalization('generalfaq', 'general_questions_heading') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseOne" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingOne" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="general-questions-accordion">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="general-questions-accordion-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseOne" aria-expanded="false" aria-controls="general-questions-accordion-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'why_posting_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="general-questions-accordion-collapseOne" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingOne" data-bs-parent="#general-questions-accordion">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'workfrater_provides_tools') }}</p>
                                            <h6>{{ getJsonLocalization('generalfaq', 'automatic_interview_system') }}</h6>
                                            <p>{{ getJsonLocalization('generalfaq', 'automatic_interview_description') }}</p>
                                            <h6>{{ getJsonLocalization('generalfaq', 'comprehensive_assessment_tests') }}</h6>
                                            <p>{{ getJsonLocalization('generalfaq', 'assessment_tests_description') }}</p>
                                            <h6>{{ getJsonLocalization('generalfaq', 'advanced_filtering_options') }}</h6>
                                            <p>{{ getJsonLocalization('generalfaq', 'filtering_options_description') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'streamlined_recruitment') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTwo" aria-expanded="false" aria-controls="general-questions-accordion-collapseTwo">
                                        {{ getJsonLocalization('generalfaq', 'whySearchJob') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseTwo" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTwo" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'benefitsWorkFrater') }}</p>
                                        <h6>{{ getJsonLocalization('generalfaq', 'profileVisibility') }}</h6>
                                        <p>{{ getJsonLocalization('generalfaq', 'visibilityDescription') }}</p>
                                        <h6>{{ getJsonLocalization('generalfaq', 'expandOpportunities') }}</h6>
                                        <p>{{ getJsonLocalization('generalfaq', 'platformGrowth') }}</p>
                                        <p>{{ getJsonLocalization('generalfaq', 'partnershipMessage') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseThree" aria-expanded="false" aria-controls="general-questions-accordion-collapseThree">
                                        {{ getJsonLocalization('generalfaq', 'mobileAppQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseThree" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingThree" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'mobileAppDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingFour">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseFour" aria-expanded="false" aria-controls="general-questions-accordion-collapseFour">
                                        {{ getJsonLocalization('generalfaq', 'accountCreationCostQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseFour" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingFour" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'accountCreationCostDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingFive">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseFive" aria-expanded="false" aria-controls="general-questions-accordion-collapseFive">
                                        {{ getJsonLocalization('generalfaq', 'availableLanguagesQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseFive" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingFive" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'availableLanguagesDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingSix">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseSix" aria-expanded="false" aria-controls="general-questions-accordion-collapseSix">
                                        {{ getJsonLocalization('generalfaq', 'hostingServerQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseSix" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingSix" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'hostingServerDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingSeven">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseSeven" aria-expanded="false" aria-controls="general-questions-accordion-collapseSeven">
                                        {{ getJsonLocalization('generalfaq', 'programmingLanguageQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseSeven" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingSeven" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'programmingLanguageDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingEight">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseEight" aria-expanded="false" aria-controls="general-questions-accordion-collapseEight">
                                        {{ getJsonLocalization('generalfaq', 'mobileVersionFunctionalityQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseEight" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingEight" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'mobileVersionFunctionalityDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingNine">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseNine" aria-expanded="false" aria-controls="general-questions-accordion-collapseNine">
                                        {{ getJsonLocalization('generalfaq', 'identityTheftPreventionQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseNine" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingNine" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'identityTheftPreventionDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingTen">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTen" aria-expanded="false" aria-controls="general-questions-accordion-collapseTen">
                                        {{ getJsonLocalization('generalfaq', 'accountTypesQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseTen" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTen" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'accountTypesDescription') }}</p>
                                        <ul class="bulleted-list">
                                            <li><b>{{ getJsonLocalization('generalfaq', 'individualAccount') }}:</b> {{ getJsonLocalization('generalfaq', 'individualAccountDescription') }}</li>
                                            <li><b>{{ getJsonLocalization('generalfaq', 'enterpriseAccount') }}:</b> {{ getJsonLocalization('generalfaq', 'enterpriseAccountDescription') }}</li>
                                            <li><b>{{ getJsonLocalization('generalfaq', 'educationAccount') }}:</b> {{ getJsonLocalization('generalfaq', 'educationAccountDescription') }}</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingEleven">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseEleven" aria-expanded="false" aria-controls="general-questions-accordion-collapseEleven">
                                        {{ getJsonLocalization('generalfaq', 'contactWorkfraterQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseEleven" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingEleven" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'contactWorkfraterDescription') }}</p>
                                        <p><a href="/public/general-inquiries" class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'generalInquiries') }}</a></p>
                                        <p><a href="/public/tech-support" class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'techSupport') }}</a></p>
                                        <p><a href="/public/customer-service" class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'customerSupport') }}</a></p>
                                        <p><a href="/public/book-an-online-presentation" class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'bookOnlinePresentation') }}</a></p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="general-questions-accordion-headingTwelve">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTwelve" aria-expanded="false" aria-controls="general-questions-accordion-collapseTwelve">
                                        {{ getJsonLocalization('generalfaq', 'learnToUseWebsiteQuestion') }}
                                    </button>
                                </h2>
                                <div id="general-questions-accordion-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTwelve" data-bs-parent="#general-questions-accordion">
                                    <div class="accordion-body">
                                        <p>{{ getJsonLocalization('generalfaq', 'learnToUseWebsiteDescription') }}</p>
                                    </div>
                                </div>
                            </div>
                            </div>
                            
                        </div>
                    </div>
                </div>

                <!-- <div class="accordion-item position-relative">
                    <div class="faq-target" id="basic-functionalites"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseTwo" aria-expanded="false" aria-controls="faqCategories-accordion-collapseTwo">
                            {{ getJsonLocalization('generalfaq', 'sectionTitle') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseTwo" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingTwo" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="basic-functionalities">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseOne" aria-expanded="false" aria-controls="basic-functionalities-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'postContentQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseOne" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingOne" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'postContentAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseTwo" aria-expanded="false" aria-controls="basic-functionalities-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'messageAndCallQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseTwo" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingTwo" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'messageAndCallAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseThree" aria-expanded="false" aria-controls="basic-functionalities-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'jobOffersQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseThree" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingThree" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'jobOffersAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseFour" aria-expanded="false" aria-controls="basic-functionalities-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'blockUsersQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseFour" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingFour" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'blockUsersAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseFive" aria-expanded="false" aria-controls="basic-functionalities-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'terminateAccountQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseFive" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingFive" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'terminateAccountAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseSix" aria-expanded="false" aria-controls="basic-functionalities-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'changeUsernameQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseSix" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingSix" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'changeUsernameAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseSeven" aria-expanded="false" aria-controls="basic-functionalities-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'changePasswordQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseSeven" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingSeven" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'changePasswordAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseEight" aria-expanded="false" aria-controls="basic-functionalities-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'deleteMessageQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseEight" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingEight" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'deleteMessageAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="basic-functionalities-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseNine" aria-expanded="false" aria-controls="basic-functionalities-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'mobileChatQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="basic-functionalities-collapseNine" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingNine" data-bs-parent="#basic-functionalities">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'mobileChatAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="video-calls"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseThree" aria-expanded="false" aria-controls="faqCategories-accordion-collapseThree">
                            {{ getJsonLocalization('generalfaq', 'videoCallsTitle') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseThree" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingThree" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="video-calls">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseOne" aria-expanded="false" aria-controls="video-calls-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'videoCallWithoutAccount') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseOne" class="accordion-collapse collapse" aria-labelledby="video-calls-headingOne" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoCallWithoutAccountAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseTwo" aria-expanded="false" aria-controls="video-calls-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'recordingVideoCalls') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseTwo" class="accordion-collapse collapse" aria-labelledby="video-calls-headingTwo" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'recordingVideoCallsAnswer') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'recordingRestriction') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseThree" aria-expanded="false" aria-controls="video-calls-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'shareScreenDuringCall') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseThree" class="accordion-collapse collapse" aria-labelledby="video-calls-headingThree" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'screenSharingExplanation') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'screenSharingLimitations') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFour" aria-expanded="false" aria-controls="video-calls-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'findRecordedVideos') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseFour" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFour" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'recordedVideosLocation') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFive" aria-expanded="false" aria-controls="video-calls-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'videoCallWindowChat') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseFive" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFive" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'chatFunctionalityAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSix" aria-expanded="false" aria-controls="video-calls-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'browserSupport') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseSix" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSix" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'browserSupportAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSeven" aria-expanded="false" aria-controls="video-calls-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'webcamSupport') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseSeven" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSeven" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'webcamSupportAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseEight" aria-expanded="false" aria-controls="video-calls-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'pluginRequirement') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseEight" class="accordion-collapse collapse" aria-labelledby="video-calls-headingEight" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'pluginRequirementAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="doing-online-exams"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseFour" aria-expanded="false" aria-controls="faqCategories-accordion-collapseFour">
                            {{ getJsonLocalization('generalfaq', 'doingOnlineExamsTitle') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseFour" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingFour" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="doing-online-exams">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseOne" aria-expanded="false" aria-controls="doing-online-exams-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'howExamsWork') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseOne" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingOne" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'howExamsWorkText') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwo" aria-expanded="false" aria-controls="doing-online-exams-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'whyUsingOurExams') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTwo" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwo" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'whyUsingOurExamsText') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'limitations') }}:</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsSmallPoolQuestions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsSmallPoolExams') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsCheating') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsChatbots') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'solutions') }}:</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsGrowingQuestions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsLargeExams') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsRecordedWebcam') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsRecordedScreen') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThree" aria-expanded="false" aria-controls="doing-online-exams-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'whatAreMainCategories') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseThree" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThree" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'whatAreMainCategoriesText') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'programmingLanguages') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', '3DEngine') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'AIandML') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'scienceAndEngineering') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'databases') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'jsFrameworks') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'pythonFrameworks') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'javaFrameworks') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'csharpFrameworks') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'phpFrameworks') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'videoEditing') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'cybersecurity') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'adobeSuite') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'musicSound') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'spokenLanguages') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'officeSoftware') }}</b></p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'cms') }}</b></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFour" aria-expanded="false" aria-controls="doing-online-exams-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'connectionOrWebcamIssue') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseFour" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFour" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'connectionOrWebcamIssueText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFive" aria-expanded="false" aria-controls="doing-online-exams-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'failedExamRetry') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseFive" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFive" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'failedExamRetryText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSix" aria-expanded="false" aria-controls="doing-online-exams-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'serverDownIssue') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseSix" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSix" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'serverDownIssueText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSeven" aria-expanded="false" aria-controls="doing-online-exams-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'headingSeven') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseSeven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSeven" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven_2') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven_3') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEight" aria-expanded="false" aria-controls="doing-online-exams-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'headingEight') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseEight" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEight" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyEight') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseNine" aria-expanded="false" aria-controls="doing-online-exams-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'headingNine') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseNine" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingNine" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyNine') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTen" aria-expanded="false" aria-controls="doing-online-exams-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'headingTen') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTen" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <h6>{{ getJsonLocalization('generalfaq', 'headingTen_strict') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'strictOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictSix') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictSeven') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictEight') }}</li>
                                            </ul>
                                            <h6>{{ getJsonLocalization('generalfaq', 'headingTen_allowed') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedFive') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEleven" aria-expanded="false" aria-controls="doing-online-exams-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'headingEleven') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseEleven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEleven" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <h6>{{ getJsonLocalization('generalfaq', 'bodyEleven') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationSix') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationSeven') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwelve" aria-expanded="false" aria-controls="doing-online-exams-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'headingTwelve') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwelve" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyTwelve') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingThirteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThirteen" aria-expanded="false" aria-controls="doing-online-exams-collapseThirteen">
                                            {{ getJsonLocalization('generalfaq', 'headingThirteen') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseThirteen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThirteen" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyThirteen') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="creating-job-offers"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseFive" aria-expanded="false" aria-controls="faqCategories-accordion-collapseFive">
                            {{ getJsonLocalization('generalfaq', 'heading') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseFive" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingFive" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="creating-job-offers">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseOne" aria-expanded="false" aria-controls="creating-job-offers-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'headingOne') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseOne" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingOne" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphOne') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseTwo" aria-expanded="false" aria-controls="creating-job-offers-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'headingTwo') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTwo" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingTwo" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphTwo') }}</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemSix') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseThree" aria-expanded="false" aria-controls="creating-job-offers-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'headingThree') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseThree" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingThree" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphThree') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseFour" aria-expanded="false" aria-controls="creating-job-offers-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'headingFour') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseFour" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingFour" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphFour') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseFive" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'test_candidate_without_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseFive" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingFive" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'test_candidate_explanation_1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'test_candidate_explanation_2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseSix" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'job_offer_board') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseSix" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingSix" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'job_offer_board_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_list') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_results') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_statistics') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_summary') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_videos') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_documents') }}</b></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseSeven" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'individual_candidate_pdf') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseSeven" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingSeven" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_identity') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_site_info') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_test_results') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_availability') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseEight" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'global_job_offer_pdf') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseEight" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingEight" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_applicants') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_test_results') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_statistics') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_summary') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseNine" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'selecting_right_candidate') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseNine" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingNine" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_video_interviews') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_suggested_questions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_test_assessments') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseTen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'terminate_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingTen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'terminate_job_offer_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseEleven" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'pause_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseEleven" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingEleven" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'pause_job_offer_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseTwelve" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'create_job_offer_mobile') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTwelve" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingTwelve" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'create_job_offer_mobile_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingThirteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseThirteen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseThirteen">
                                            {{ getJsonLocalization('generalfaq', 'watch_video_exams_mobile') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseThirteen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingThirteen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'watch_video_exams_mobile_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingForteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseForteen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseForteen">
                                            {{ getJsonLocalization('generalfaq', 'prevent_someone_apply') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseForteen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingForteen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'prevent_someone_apply_desc') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'block_user_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="buying-exams"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseSix" aria-expanded="false" aria-controls="faqCategories-accordion-collapseSix">
                            {{ getJsonLocalization('generalfaq', 'buyingExamsAndPdf') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseSix" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingSix" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="buying-exams-and-pdfs">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseOne" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'examVideoQuestion1') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseOne" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingOne" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examVideoAnswer1') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseTwo" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'examPriceQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseTwo" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingTwo" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examPriceAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseThree" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'examRefundQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseThree" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingThree" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examRefundAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseFour" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'examShareQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseFour" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingFour" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examShareAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseFive" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'examStoreQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseFive" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingFive" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examStoreAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseSix" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'examDeleteQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseSix" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingSix" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examDeleteAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseSeven" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'examVisibilityQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseSeven" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingSeven" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examVisibilityAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="buying-exams-and-pdfs-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseEight" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'examLanguageQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="buying-exams-and-pdfs-collapseEight" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingEight" data-bs-parent="#buying-exams-and-pdfs">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'examLanguageAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="automatic-video-interviews"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseSeven" aria-expanded="false" aria-controls="faqCategories-accordion-collapseSeven">
                            {{ getJsonLocalization('generalfaq', 'buttonAutomaticVideoInterviews') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseSeven" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingSeven" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="automatic-video-interviews">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseOne" aria-expanded="false" aria-controls="automatic-video-interviews-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'videoInterviewIntro') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseOne" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingOne" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewExplanation1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewExplanation2') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewExplanation3') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewExplanation4') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseTwo" aria-expanded="false" aria-controls="automatic-video-interviews-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'videoInterviewRequirements') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseTwo" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingTwo" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewRequirementsExplanation1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewRequirementsExplanation2') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseThree" aria-expanded="false" aria-controls="automatic-video-interviews-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseThree" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingThree" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendationIntro') }}</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation1') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation2') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation3') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation4') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'videoInterviewRecommendation5') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseFour" aria-expanded="false" aria-controls="automatic-video-interviews-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'questionWhereToWatchVideo') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseFour" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingFour" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerWhereToWatchVideo') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseFive" aria-expanded="false" aria-controls="automatic-video-interviews-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'questionCanShareVideoPublic') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseFive" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingFive" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerCanShareVideoPublic') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseSix" aria-expanded="false" aria-controls="automatic-video-interviews-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'questionWatchMobileDevice') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseSix" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingSix" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerWatchMobileDevice') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseSeven" aria-expanded="false" aria-controls="automatic-video-interviews-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'questionForbidMobileInterview') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseSeven" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingSeven" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerForbidMobileInterview') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseEight" aria-expanded="false" aria-controls="automatic-video-interviews-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'questionTimeLimitForQuestions') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseEight" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingEight" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerTimeLimitForQuestions') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseNine" aria-expanded="false" aria-controls="automatic-video-interviews-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'questionCanSkipQuestion') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseNine" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingNine" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerCanSkipQuestion') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="automatic-video-interviews-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseTen" aria-expanded="false" aria-controls="automatic-video-interviews-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'questionSendVideoWithoutJobOffer') }}
                                        </button>
                                    </h2>
                                    <div id="automatic-video-interviews-collapseTen" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingTen" data-bs-parent="#automatic-video-interviews">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'answerSendVideoWithoutJobOffer') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="education-accounts"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingEight">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseEight" aria-expanded="false" aria-controls="faqCategories-accordion-collapseEight">
                            {{ getJsonLocalization('generalfaq', 'education_accounts_and_online_classrooms') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseEight" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingEight" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="education-account-n-classrooms">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseOne" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'what_are_online_classrooms') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseOne" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingOne" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'online_classrooms_description') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'teach_students_safely') }}</b> {{ getJsonLocalization('generalfaq', 'teach_students_safely_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'monitor_students_during_exams') }}</b> {{ getJsonLocalization('generalfaq', 'monitor_students_during_exams_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'create_online_tests') }}</b> {{ getJsonLocalization('generalfaq', 'create_online_tests_desc') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTwo" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'why_should_school_create_account') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseTwo" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTwo" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'advantages_of_creating_account') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'student_visibility') }}</b> {{ getJsonLocalization('generalfaq', 'student_visibility_desc') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'online_classrooms') }}</b> {{ getJsonLocalization('generalfaq', 'online_classrooms_desc') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseThree" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'how_students_join') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseThree" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingThree" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'how_students_join_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFour" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'how_teachers_join') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseFour" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFour" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'how_teachers_join_desc1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'how_teachers_join_desc2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFive" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'student_without_webcam') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseFive" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFive" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'student_without_webcam_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSix" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'student_with_mobile_device') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseSix" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSix" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'student_with_mobile_device_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSeven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'record_students_screen') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseSeven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSeven" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'record_students_screen_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEight" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'where_to_find_recordings') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseEight" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEight" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'where_to_find_recordings_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseNine" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'participant_screen_share') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseNine" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingNine" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'participant_screen_share_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTen" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'what_is_recorded') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseTen" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTen" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'what_is_recorded_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="education-account-n-classrooms-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEleven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'classroom_participant_limit') }}
                                        </button>
                                    </h2>
                                    <div id="education-account-n-classrooms-collapseEleven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEleven" data-bs-parent="#education-account-n-classrooms">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'classroom_participant_limit_desc') }} <a href='/public/fees-and-subscription' class="text-secondary no-decoration">{{ getJsonLocalization('generalfaq', 'price_range_for_plans') }}</a>.</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="becoming-entreprenure"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingNine">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseNine" aria-expanded="false" aria-controls="faqCategories-accordion-collapseNine">
                        {{ getJsonLocalization('generalfaq', 'becoming_an_entrepreneur_on_the_platform') }}
                    </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseNine" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingNine" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="becoming-an-entrepreneur">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseOne" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'howToBecomeEntrepreneur') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseOne" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingOne" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'entrepreneurDescription') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwo" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'whyShareProject') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTwo" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwo" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'sharingBenefits') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'increaseVisibility') }}:</b> {{ getJsonLocalization('generalfaq', 'increaseVisibilityDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'buildConnections') }}:</b> {{ getJsonLocalization('generalfaq', 'buildConnectionsDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'crowdfundingOpportunities') }}:</b> {{ getJsonLocalization('generalfaq', 'crowdfundingOpportunitiesDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'professionalFeedback') }}:</b> {{ getJsonLocalization('generalfaq', 'professionalFeedbackDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'globalReach') }}:</b> {{ getJsonLocalization('generalfaq', 'globalReachDescription') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'platformExposure') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseThree" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'stepsToPublishProject') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseThree" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingThree" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'projectPublishSteps') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'createProject') }}:</b> {{ getJsonLocalization('generalfaq', 'createProjectDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'fillForm') }}:</b> {{ getJsonLocalization('generalfaq', 'fillFormDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'videoInterview') }}:</b> {{ getJsonLocalization('generalfaq', 'videoInterviewDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'publishProject') }}:</b> {{ getJsonLocalization('generalfaq', 'publishProjectDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'engageWithOthers') }}:</b> {{ getJsonLocalization('generalfaq', 'engageWithOthersDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'updateVideos') }}:</b> {{ getJsonLocalization('generalfaq', 'updateVideosDescription') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'buildConnectionsDescription') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFour" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'fieldsForm') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseFour" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFour" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'fieldsFormDescription') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'enterpriseName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'location') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'personalInfo') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'interests') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'website') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectType') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'developmentStage') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'team') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'initialFunds') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'fundsRequired') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'expansionPlans') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'fieldsInfo') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFive" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'videoInterviewQuestions') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseFive" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFive" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewDescription') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'executiveSummary') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'businessDescription') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'marketAnalysis') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'organizationManagement') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'productsOrServices') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'marketingSalesStrategy') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'operationalPlan') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'financialPlan') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'growthExpansionPlans') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewDetails') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSix" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'projectVisibility') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseSix" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSix" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'projectVisibilityDescription') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'filtersAndSearch') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSection') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSeven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'forYouSectionHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseSeven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSeven" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSectionText1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSectionText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEight" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'searchForProjectHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseEight" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEight" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'searchForProjectText1') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'entrepreneurName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'ethnicity') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'countryOfOrigin') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectType') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'location') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'searchForProjectText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseNine" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'disallowedProjectsHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseNine" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingNine" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'disallowedProjectsText1') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'cryptocurrency') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'pornography') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'gambling') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'barsAndClubs') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'drugs') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'alcohol') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'disallowedProjectsText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTen" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'financeProjectHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTen" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTen" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'financeProjectText1') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEleven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'getPaidHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseEleven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEleven" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'getPaidText') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwelve" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'reportFraudHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwelve" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'reportFraudText') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item position-relative">
                    <div class="faq-target" id="confidentiality-safety-payment"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingTen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseTen" aria-expanded="false" aria-controls="faqCategories-accordion-collapseTen">
                            {{ getJsonLocalization('generalfaq', 'confidentiality_safety_and_payment') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseTen" class="accordion-collapse collapse" aria-labelledby="faqCategories-accordion-headingTen" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="confidentiality-safety-and-payment">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseOne" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'private_financial_information') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseOne" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingOne" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'private_financial_information_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseTwo" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'braintree_description') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseTwo" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingTwo" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'braintree_description_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseThree" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'view_bills') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseThree" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingThree" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'view_bills_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseFour" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'missing_payment') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseFour" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingFour" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'missing_payment_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseFive" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'messages_visible') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseFive" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingFive" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'messages_visible_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseSix" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'delete_account_information') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseSix" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingSix" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'delete_account_information_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseSeven" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'view_bills_mobile') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseSeven" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingSeven" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'view_bills_mobile_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseEight" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'bill_information') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseEight" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingEight" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bill_information_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseNine" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'currency_used') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseNine" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingNine" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'currency_used_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseTen" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'payment_method_issue') }}
                                        </button>
                                    </h2>
                                    <div id="confidentiality-safety-and-payment-collapseTen" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingTen" data-bs-parent="#confidentiality-safety-and-payment">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'payment_method_issue_answer') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

            </div>
        </div>
    </section>



    <!-- GENERAL QUESTIONS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">GENERAL QUESTIONS</h4>
        <div class="accordion" id="general-questions-accordion">
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseOne" aria-expanded="false" aria-controls="general-questions-accordion-collapseOne">
                    Why posting a job offer on Workfrater?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseOne" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingOne" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>WorkFrater provides all the tools you need to ensure the candidates you interview and hire meet your qualifications.</p>
                    <h6>Automatic Interview System</h6>
                    <p>The platform features an innovative automatic interview system where the site’s A.I. asks candidates pre-defined questions while recording their responses on video. This recorded video becomes part of the candidate’s profile, accessible to recruiters at any time. When posting a job offer, you can customize the interview process by adding your own questions and requiring applicants to complete the automatic interview before submitting their applications.</p>
                    <h6>Comprehensive Assessment Tests</h6>
                    <p>WorkFrater offers a wide range of assessment tests that any user can take. To ensure fairness and integrity, the platform monitors both the candidate’s webcam and screen activity during these tests, recording the session to prevent cheating. These recordings are available for recruiters to review. The more tests a candidate completes, the more visible their profile becomes in search results and recommendation sections. Employers can also mandate specific tests for candidates to complete as part of the application process.</p>
                    <h6>Advanced Filtering Options</h6>
                    <p>WorkFrater provides robust filters for employers, allowing limited interactions with candidates who don’t meet your criteria. For example, you can restrict applications and messages to candidates within your country. Other customizable filters include age, spoken languages, ethnic background, and more, making it easier to target specific demographic needs, such as hiring candidates from underrepresented groups or minorities.</p>
                    <p>With these tools, WorkFrater ensures a streamlined and efficient recruitment process tailored to your needs.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTwo" aria-expanded="false" aria-controls="general-questions-accordion-collapseTwo">
                    WHY SEARCHING FOR A JOB ON WORKFRATER?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseTwo" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTwo" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>WorkFrater offers several benefits to job seekers that set it apart from other employment platforms.</p>
                    <h6>Enhanced Profile Visibility through Rankings</h6>
                    <p>WorkFrater features a unique ranking system where job seekers who complete more assessment tests rank higher in search results. By participating in a variety of tests, your profile gains greater visibility, making it easier for potential employers to find and notice you. This increased visibility improves your chances of connecting with recruiters and interacting with them directly.</p>
                    <h6>Expanding Opportunities through Platform Growth</h6>
                    <p>With its wide range of functionalities and innovative features, WorkFrater is designed to attract a growing number of employers and recruiters. As the platform expands, job seekers can expect more opportunities to connect with reputable organizations and land their dream jobs.</p>
                    <p>WorkFrater isn’t just a job platform—it’s your partner in standing out and securing the right opportunities.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseThree" aria-expanded="false" aria-controls="general-questions-accordion-collapseThree">
                    Does Workfrater has a mobile app?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseThree" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingThree" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>The mobile app is currently in development and will soon be available on Google Play and the App Store.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseFour" aria-expanded="false" aria-controls="general-questions-accordion-collapseFour">
                    How much does it cost to create an account on Workfrater?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseFour" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingFour" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>Basic accounts are free for individuals, employers, and educational institutions. For a detailed overview of our pricing for advanced services, please visit our <a href="#">Pricing</a> page.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseFive" aria-expanded="false" aria-controls="general-questions-accordion-collapseFive">
                    In how many languages the website is available.
                </button>
                </h2>
                <div id="general-questions-accordion-collapseFive" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingFive" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>The website is currently available in French and English, as our primary focus at this stage is on Canada, the U.S., the U.K., and France. A Spanish version of the website will come soon.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseSix" aria-expanded="false" aria-controls="general-questions-accordion-collapseSix">
                    The website is hosted on which server?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseSix" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingSix" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>The website is hosted on Hostinger servers. The website use one server for the website and it's contents and another server for all the videos that are recorded during video calls, interviews and exams.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseSeven" aria-expanded="false" aria-controls="general-questions-accordion-collapseSeven">
                    The website was coded in which programming language?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseSeven" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingSeven" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>WorkFrater is primarily programmed using PHP Laravel. The video server, which stores and processes videos, runs a Java application that executes FFmpeg command lines.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseEight" aria-expanded="false" aria-controls="general-questions-accordion-collapseEight">
                    Does the mobile version of the website has the same functionalities as the desktop one?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseEight" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingEight" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>Some functionalities have been intentionally omitted from the mobile version of WorkFrater for practical and security reasons. For instance, users cannot complete online exams on mobile devices, as the platform requires both the user and their screen to be recorded simultaneously. Additionally, users cannot record videos from their cellphones or mobile devices during video calls.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseNine" aria-expanded="false" aria-controls="general-questions-accordion-collapseNine">
                    what are the measures that Workfrater uses to prevent identity theft and fake accounts?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseNine" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingNine" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>Like many social media platforms, WorkFrater implements measures to verify the identity of its users. To verify their account, a user can submit a copy of a national ID, driver's license, or passport. This document will only be accessible to the WorkFrater team. The verification option is available in the Personal Information section on the settings page.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTen" aria-expanded="false" aria-controls="general-questions-accordion-collapseTen">
                    How many types of accounts exist on WorkFrater?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseTen" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTen" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>This platform offers three different types of accounts:</p>
                    <ul class="bulleted-list">
                        <li><b>Individual:</b> Designed for individuals seeking job opportunities, networking with employers, and promoting entrepreneurial projects. Students can also use this account to access virtual classrooms and complete exams.</li>
                        <li><b>Enterprise:</b> Ideal for companies to create job postings, send online evaluations to candidates to assess their skills, and search for potential hires using a powerful search engine.</li>
                        <li><b>Education:</b> Tailored for educational institutions such as colleges, universities, trade schools, online schools and others to create virtual classrooms for their students. Teachers within these institutions can use the platform to conduct lessons and administer online tests. During these sessions, the platform can record the screen and webcam of each student. Teachers can review the recordings to ensure students followed instructions during a class or an exam.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingEleven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseEleven" aria-expanded="false" aria-controls="general-questions-accordion-collapseEleven">
                    How can I contact Workfrater?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseEleven" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingEleven" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>We have several pages that you can visit to contact us, ask us questions and learn more about the platform:</p>
                    <p><a href="#">General inquiries:</a> Ask us any questions you want, we will reply to you in less than 24 hours.</p>
                    <p><a href="#">Tech support:</a> Contact us to solve any problem you have with your account, the website’s functionalities or any other technical matter.</p>
                    <p><a href="#">Customer support:</a>  Use this page if you have issues with a payment, a bill or any of our products.</p>
                    <p><a href="#">Book an online presentation:</a> Our team can present to you and your organization all the functionalities of this platform. Simply fill the form and our team will contact you.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="general-questions-accordion-headingTwelve">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general-questions-accordion-collapseTwelve" aria-expanded="false" aria-controls="general-questions-accordion-collapseTwelve">
                    How can I learn to use the website by myself?
                </button>
                </h2>
                <div id="general-questions-accordion-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="general-questions-accordion-headingTwelve" data-bs-parent="#general-questions-accordion">
                <div class="accordion-body">
                    <p>You can learn about the website's functionalities by visiting our <a href="#">tutorial</a> page. The page features several articles on topics such as signing up, creating or searching for job offers, finding people, setting up payment methods, and much more.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- BASIC FUNCTIONALITIES -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">BASIC FUNCTIONALITIES</h4>
        <div class="accordion" id="basic-functionalities">
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseOne" aria-expanded="false" aria-controls="basic-functionalities-collapseOne">
                    Is it possible to post contents on Workfrater?
                </button>
                </h2>
                <div id="basic-functionalities-collapseOne" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingOne" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, although it is a job platform, WorkFrater incorporates many social media functionalities such as posting content, sharing, following, and commenting.</p>
                    <p>The content posted by the people you follow will appear on your feed as you scroll. Similarly, your content will appear on the feeds of those who follow you.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseTwo" aria-expanded="false" aria-controls="basic-functionalities-collapseTwo">
                    Is it possible to message and video call on this platform?
                </button>
                </h2>
                <div id="basic-functionalities-collapseTwo" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingTwo" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, users can chat, message, and video call other users on WorkFrater. Additionally, they have the ability to record their video calls, and the recordings will be available for viewing or downloading on the video page.</p>
                    <p>Employers can also set filters to determine who can message them. For example, they can choose to allow messages only from users in specific countries.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseThree" aria-expanded="false" aria-controls="basic-functionalities-collapseThree">
                    How job offers work on this platform?
                </button>
                </h2>
                <div id="basic-functionalities-collapseThree" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingThree" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Any employer can post a job offer on the platform. The process begins by entering the job requirements, followed by the option to add written questions that candidates must answer.
                        Employers can also require candidates to complete a video interview. The website will display the questions on the candidate's screen while recording their responses. The recorded video will then be available to the employer for review.
                        Additionally, employers can select a list of tests that every candidate must complete before applying for the job.
                    </p>
                    <p>Finally, employers have the option to apply filters to their job offer to prevent candidates who do not meet the specified requirements from applying.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseFour" aria-expanded="false" aria-controls="basic-functionalities-collapseFour">
                    Is it possible to block users ?
                </button>
                </h2>
                <div id="basic-functionalities-collapseFour" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingFour" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, it is possible to block any user from the settings page. When a user is blocked, they will no longer be able to contact you, view your profile on the search page, or see your posts.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseFive" aria-expanded="false" aria-controls="basic-functionalities-collapseFive">
                    Is it possible to terminate my account?
                </button>
                </h2>
                <div id="basic-functionalities-collapseFive" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingFive" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, you can either terminate your account (which means it cannot be recovered) or pause it until you return.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseSix" aria-expanded="false" aria-controls="basic-functionalities-collapseSix">
                    Is it possible to change my username?
                </button>
                </h2>
                <div id="basic-functionalities-collapseSix" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingSix" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>No, a user cannot change their username, and a company cannot change its name either. Additionally, birthdays cannot be modified.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseSeven" aria-expanded="false" aria-controls="basic-functionalities-collapseSeven">
                    Is it possible to change my password?
                </button>
                </h2>
                <div id="basic-functionalities-collapseSeven" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingSeven" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, you can change your password at any time on the settings page under the password tab.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseEight" aria-expanded="false" aria-controls="basic-functionalities-collapseEight">
                    Is it possible to delete a message or a conversation?
                </button>
                </h2>
                <div id="basic-functionalities-collapseEight" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingEight" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>Yes, you can delete conversations on your end, but the other person will still have their version of the conversations.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="basic-functionalities-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#basic-functionalities-collapseNine" aria-expanded="false" aria-controls="basic-functionalities-collapseNine">
                    is the chat functionality available on the mobile website?
                </button>
                </h2>
                <div id="basic-functionalities-collapseNine" class="accordion-collapse collapse" aria-labelledby="basic-functionalities-headingNine" data-bs-parent="#basic-functionalities">
                <div class="accordion-body">
                    <p>You can receive messages in real-time, but you must use the standard messaging function. The mobile website does not support pop-up chat windows. To communicate, you need to access the messages page.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- VIDEO CALLS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">VIDEO CALLS</h4>
        <div class="accordion" id="video-calls">
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseOne" aria-expanded="false" aria-controls="video-calls-collapseOne">
                    Is it possible to video call without an account?
                </button>
                </h2>
                <div id="video-calls-collapseOne" class="accordion-collapse collapse" aria-labelledby="video-calls-headingOne" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>Yes, you can video call someone even without an account, and the person you're calling doesn't need an account either. Simply press the video call button in the first section of the website, and you'll receive instructions to start the call. Similar to platforms like Google Meet or Zoom, a URL link will be provided, which you can send to the person you want to call.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseTwo" aria-expanded="false" aria-controls="video-calls-collapseTwo">
                    How can I record my video calls?
                </button>
                </h2>
                <div id="video-calls-collapseTwo" class="accordion-collapse collapse" aria-labelledby="video-calls-headingTwo" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>You can record a video call only if you have an account. On the video call page, you'll find a record button at the bottom of the video feed. Press the button to start recording and choose what to record: your screen (the presenter), the screen of the person you are interviewing, or multiple screens.</p>
                    <p>Please note that recording is not available on cellphones or other mobile devices. Additionally, during a video call, only the presenter is allowed to record the session.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseThree" aria-expanded="false" aria-controls="video-calls-collapseThree">
                    Is it possible to share my screen during a video call?
                </button>
                </h2>
                <div id="video-calls-collapseThree" class="accordion-collapse collapse" aria-labelledby="video-calls-headingThree" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>Yes, like on Google Meet and Zoom, you can share your screen or a page. This functionality is only available on desktop and is not available on cellphones or mobile devices.</p>
                    <p>Only one person at a time can share their screen, and when someone shares their screen, only the screen will appear in the recorded video if the presenter is recording.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFour" aria-expanded="false" aria-controls="video-calls-collapseFour">
                    Where to find my recorded videos?
                </button>
                </h2>
                <div id="video-calls-collapseFour" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFour" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>You can find your recorded videos in the Video Section. To access this section, simply click on your profile picture at the top right of the page. There, you will find all your recorded videos, which you can watch or download.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFive" aria-expanded="false" aria-controls="video-calls-collapseFive">
                    Does the video call window has a chat functionality?
                </button>
                </h2>
                <div id="video-calls-collapseFive" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFive" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>Yes, you can chat with other participants using the chat options located on the right side of the window.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSix" aria-expanded="false" aria-controls="video-calls-collapseSix">
                    Does all web browsers support the video call functionalities?
                </button>
                </h2>
                <div id="video-calls-collapseSix" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSix" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>Yes, all web browsers should work on windows, macOs and Linux.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSeven" aria-expanded="false" aria-controls="video-calls-collapseSeven">
                    Does all webcam models work?
                </button>
                </h2>
                <div id="video-calls-collapseSeven" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSeven" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>Yes, all recent webcam models should work.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="video-calls-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseEight" aria-expanded="false" aria-controls="video-calls-collapseEight">
                    Do I need any plugin to use the video calls functionalities?
                </button>
                </h2>
                <div id="video-calls-collapseEight" class="accordion-collapse collapse" aria-labelledby="video-calls-headingEight" data-bs-parent="#video-calls">
                <div class="accordion-body">
                    <p>No, all modern browsers should be able to support all functionalities.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- DOING ONLINE EXAMS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">DOING ONLINE EXAMS</h4>
        <div class="accordion" id="doing-online-exams">
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseOne" aria-expanded="false" aria-controls="doing-online-exams-collapseOne">
                    How exams work?
                </button>
                </h2>
                <div id="doing-online-exams-collapseOne" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingOne" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>WorkFrater offers an ever-growing list of online tests that employers can use to assess their candidates. Employers can either send a candidate an email link to the exam or include the exam in their job offer. In the latter case, every person who wants to apply for the job must pass the exam before submitting their application.
                        During the exam, the website will record both the candidate's screen and webcam to prevent any form of cheating. The recorded video will then be available to the employer for review.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwo" aria-expanded="false" aria-controls="doing-online-exams-collapseTwo">
                    Why using our exams and platform to assess your candidates?
                </button>
                </h2>
                <div id="doing-online-exams-collapseTwo" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwo" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>Many job positions require a full evaluation of a candidate's skills. Jobs in programming, 2D/3D design, engineering, and other STEM fields require a comprehensive overview of a person's abilities. Many office jobs that are not necessarily in STEM also require advanced knowledge of office software like Excel, SAP, and many others. One or two interviews are not enough to properly evaluate a candidate.</p>
                    <p>Many job platforms like LinkedIn and Indeed offer assessment tests, but they are very limited for several reasons:</p>
                    <ul class="bulleted-list">
                        <li><b>A small pool of questions:</b> A candidate can retake the test later, and since the pool of questions is small, they can succeed next time by simply looking up the answers after failing.</li>
                        <li><b>A small pool of exams:</b> Many of these platforms have a very limited pool of exams. The   T.I industry is large and it is hard in many fields to find complete online exams to test candidates.</li>
                        <li><b>No safety measures to counter cheating:</b> Often, users on LinkedIn and Indeed will video call someone who is knowledgeable in the field to help them. They share their screen during the exam, and the person guides them while they take the test.</li>
                        <li><b>The rise of advanced chatbots:</b> Chatbots like ChatGPT can quickly answer virtually any question. Many candidates who take online tests use them to get excellent answers.</li>
                    </ul>
                    <p>WorkFrater offers a platform that solves all these problems by implementing several solutions:</p>
                    <ul class="bulleted-list">
                        <li><b>Growing number of questions for each test:</b> For each test on the platform, we continuously add new questions. These questions can be rephrased versions of previous questions or cover different content. The questions are randomly generated, and the large number of them makes it almost impossible for a user to get the same question.
                        </li>
                        <li><b>Large number of exams:</b> We offer assessment tests for most programming languages, Adobe Suite, game engines, JavaScript frameworks, A.I, spoken languages and much more. Moreover, the tests are subdivided into multiple levels, allowing employers to know exactly how much a candidate knows in a specific field.
                        </li>
                        <li><b>Recorded webcam:</b> During the exam, WorkFrater records the candidate's webcam. If the user leaves the field of view of the webcam or closes it, the exam is immediately terminated. Likewise, if the user is seen using their cellphone or another device during the exam, the employer will be able to see it when reviewing the video.
                        </li>
                        <li><b>Recorded screen:</b> In addition to recording the webcam, WorkFrater also records the candidate’s entire screen. This way, the employer will be able to see if the candidate visited websites or used apps that they should not have while watching the video.
                        </li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThree" aria-expanded="false" aria-controls="doing-online-exams-collapseThree">
                    What are the main categories of exams that the platform possesses? 
                </button>
                </h2>
                <div id="doing-online-exams-collapseThree" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThree" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>The platform offers a variety of exam categories that are continuously expanding. Both the number of exams and the pool of questions within each test are regularly updated, ensuring that users are less likely to encounter the same questions when retaking an exam.</p>
                    <p>Here are the main categories for the exams:</p>
                    <p><b>Programming languages/frameworks:</b> C++, Python, C#, Java, JavaScript, HTML, CSS, PHP, Swift, Ruby, Dart, Go, Kotlin </p>
                    <p><b>3D engine:</b> Blender, Unreal engine, Maya, Unity 3D, Cryengine, Godot, 3ds max, adobe substance designer, adobe substance painter, Quixel, Zbrush</p>
                    <p><b>A.I and machine learning:</b>  Tensorflow, Pytorch, Google cloud AI platform, Amazon sagemaker, Azure machine learning, Watson studio, NVidia GPU cloud, Open Ai API, keras, sci-kit learn</p>
                    <p><b>Science and engineering:</b> Matlab, AutoCAD 2d , AutoCAD 3d, GNU octave, R, Julia, Scilab, Mathematica</p>
                    <p><b>Databases:</b> MySQL, PostgreSQL, SQLite, Microsoft SQL, MongoDB (json), S&P</p>
                    <p><b>JavaScript frameworks:</b>  React, Angular, Vue,  Node,  Express,  Ember, Next</p>
                    <p><b>Python frameworks:</b>  Django, Flask, Cherry pi, cherry pi, pytorch, </p>
                    <p><b>Java frameworks:</b> Spring, Hibernate, Apache struts, Play frameworks,  Grails, Vaadin,  Quarkus, Micronauts, Javafx, Swing</p>
                    <p><b>C# frameworks:</b> Asp.net, Winforms, WPF, Entity framework, Xamarin, Blazor, </p>
                    <p><b>PHP frameworks:</b> Laravel, Symfony, Codeigniter, YII2, Zend, Phalcon,</p>
                    <p><b>Video editing:</b> Premiere pro, final cut. Davinci resolve, Vegas pro, Hitfilm pro, Filmora, Lightworks, IMovie, Camtasia</p>
                    <p><b>Cybersecurity:</b> Kali Linux, Metasploit framework, Wireshark, NMAP, Snort, Burp suite, Splunk, OpenVAS, OSSEC, Palo alto Networks,  Nessus, Wifi pineapple, Qradar,  TheHive, </p>
                    <p><b>Adobe suite:</b> Photoshop, illustrator, premiere pro, after effects, InDesign, Lightroom, xd, Dreamweaver, audition, animate</p>
                    <p><b>Music/sound:</b>    Garageband, Ableton, Fruity loops studio, Logic pro, pro tools, Cubase, Reason studio</p>
                    <p><b>Spoken languages:</b> French, English, Spanish, German, Chinese, Japanese, Portuguese, Russian, Dutch</p>
                    <p><b>Office software:</b> Microsoft excel.  Microsoft Word,  Microsoft access, Microsoft project Asana, Trello</p>
                    <p><b>Content management system:</b>  joomla, wix, WordPress, squarespace, shopify, joomla, ghost, magento</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFour" aria-expanded="false" aria-controls="doing-online-exams-collapseFour">
                    What happen if during an exam, the user lose his connection, close his webcam or any other problems happen?
                </button>
                </h2>
                <div id="doing-online-exams-collapseFour" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFour" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>In this case, the exam will be automatically canceled, and the user will not be able to redo the exam unless the employer decides to allow them to retake it.</p>
                    <p>If this happens when the user is taking the test on their profile simply to obtain a badge of completion, they can contact tech support, and the exam will be made available to them again.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFive" aria-expanded="false" aria-controls="doing-online-exams-collapseFive">
                    If the user fails an exam, can he redo it?
                </button>
                </h2>
                <div id="doing-online-exams-collapseFive" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFive" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>It depends. For exams, there are two scenarios. The first scenario is when users can take exams on their own to demonstrate their skills on their profile. If they succeed in the exam, they will receive a badge that will be visible to potential employers. If the user fails an exam in this scenario, they will have to wait 30 days before attempting it again. The number of attempts before succeeding will be displayed on their profile.
                    </p>
                    <p>The second scenario involves exams that are required for a job offer. An employer can include a list of exams that a candidate must complete before applying for the job. The employer can decide whether it is a prerequisite for a candidate to pass the exam (with a score higher than 60%) to apply, or whether the candidate can still apply even if they do not pass the exam. If the candidate does not pass the exam and it was a prerequisite to apply, they will not be able to submit their application.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSix" aria-expanded="false" aria-controls="doing-online-exams-collapseSix">
                    What if during an exam, the server shot down or any other problems that do not depend on me?
                </button>
                </h2>
                <div id="doing-online-exams-collapseSix" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSix" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>You can always contact tech support if a problem arises during an online exam. We will investigate the issue and provide you with the opportunity to retake the exam if it is determined that the problem was not your fault.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSeven" aria-expanded="false" aria-controls="doing-online-exams-collapseSeven">
                    Do I have the right to close my webcam during an online exam?
                </button>
                </h2>
                <div id="doing-online-exams-collapseSeven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSeven" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>You are only permitted to turn off your camera when authorized by the site. During online exams for earning a badge, the site allows you to turn off your webcam for a brief 5-minute break, usually scheduled at the midpoint of the exam.
                    </p>
                    <p>For online exams integrated with a job offer, the employer determines the timing and duration of the pause.
                    </p>
                    <p>Placing an obstacle or object between yourself and the camera will result in automatic disqualification from the exam.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEight" aria-expanded="false" aria-controls="doing-online-exams-collapseEight">
                    What if for some reasons, during an online test, the image quality and/or the fps starts to drop?
                </button>
                </h2>
                <div id="doing-online-exams-collapseEight" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEight" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>Before taking the online exam, ensure you have a stable internet connection and that your hardware meets the necessary requirements. If you encounter issues and believe they are not your fault, you can contact tech support. We will review the situation and may provide you with a second opportunity to take the exam.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseNine" aria-expanded="false" aria-controls="doing-online-exams-collapseNine">
                    Can I do an online exam with my tablet or cellphone?
                </button>
                </h2>
                <div id="doing-online-exams-collapseNine" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingNine" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>It is strictly prohibited to take an online exam using a mobile device. The site only supports desktop and laptop computers. If you attempt to use a mobile device, the system will detect it, and the exam will not function.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTen" aria-expanded="false" aria-controls="doing-online-exams-collapseTen">
                    What Am I allowed and not allowed to do during an exam?
                </button>
                </h2>
                <div id="doing-online-exams-collapseTen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTen" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <h6>Strictly Forbidden:</h6>
                    <ul class="bulleted-list">
                        <li>Using any mobile device, or other device besides the approved desktop computer.</li>
                        <li>Viewing any screen other than the one displaying the exam website. Multi-screen setups are not permitted.</li>
                        <li>Obstructing your webcam, either partially or fully.</li>
                        <li>Wearing earbuds or earphones</li>
                        <li>Opening tabs other than those specifically allowed for the exam.</li>
                        <li>Having another person in the room while taking the exam.</li>
                        <li>Being in an environment with noise or music. The exam environment must be completely silent.</li>
                        <li>Answering a phone call or the door during the exam.</li>
                    </ul>
                    <h6>Allowed:</h6>
                    <ul class="bulleted-list">
                        <li>Before starting the exam, the website will provide a list of approved resources that you may consult during the exam. These resources must be accessed only on the same screen and browser you are using for the exam.</li>
                        <li>If permitted by the exam, you may consult a book.</li>
                        <li>Online exams for earning a badge include a 5-minute break. During this time, you may turn off your camera, take a restroom break, etc.</li>
                        <li>Online exams for job offers also provide a minimum 5-minute break. The employer determines after which questions the break occurs and may extend the duration if desired.</li>
                        <li>The employer, during an exam in a job offer, might also give you a list of websites you have the right to consult.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingEleven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEleven" aria-expanded="false" aria-controls="doing-online-exams-collapseEleven">
                    What else do you recommend during an exam?
                </button>
                </h2>
                <div id="doing-online-exams-collapseEleven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEleven" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <h6>Recommandations for Online Exams</h6>
                    <ul class="bulleted-list">
                        <li>Webcam Position: Ensure your webcam is centered on you, capturing at least the upper half of your body. The webcam should be positioned at a 0-degree angle or lower, meaning it should be perpendicular to or slightly angled downward toward your body.</li>
                        <li>Laptop Use: While laptops are allowed, adjusting the webcam can be challenging. Ensure your table is high enough so the webcam properly captures at least half of your upper body.</li>
                        <li>Lighting: Use appropriate lighting so your body is clearly visible on the screen.</li>
                        <li>Dress Code: Dress professionally. The more formal your attire, the better impression you may make on potential employers.</li>
                        <li>Eating and Drinking: While allowed, eating or drinking during the exam is not recommended.</li>
                        <li>Equipment Check: Test your microphone and webcam to ensure they function properly before starting the exam.</li>
                        <li>Application Management: Close all unnecessary applications during the exam to maximize system performance.</li>
                    </ul>  
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingTwelve">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwelve" aria-expanded="false" aria-controls="doing-online-exams-collapseTwelve">
                    The exams questions are available in which language?
                </button>
                </h2>
                <div id="doing-online-exams-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwelve" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>Currently, all exams available on the platform are in English.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="doing-online-exams-headingThirteen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThirteen" aria-expanded="false" aria-controls="doing-online-exams-collapseThirteen">
                    What is the text ticker options for online exams?
                </button>
                </h2>
                <div id="doing-online-exams-collapseThirteen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThirteen" data-bs-parent="#doing-online-exams">
                <div class="accordion-body">
                    <p>The platform allows you to create a scrolling text that moves from right to left at the bottom of the online exam window. This feature can be used to display instructions for the candidate to view while they complete the online exam.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- CREATING JOB OFFERS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">CREATING JOB OFFERS</h4>
        <div class="accordion" id="creating-job-offers">
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseOne" aria-expanded="false" aria-controls="creating-job-offers-collapseOne">
                    Can I create job offers anywhere in the world?
                </button>
                </h2>
                <div id="creating-job-offers-collapseOne" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingOne" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, you can. However, please note that all transactions and bills on the site are processed in United States dollars (USD).</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseTwo" aria-expanded="false" aria-controls="creating-job-offers-collapseTwo">
                    What are the major steps to create a job offer?
                </button>
                </h2>
                <div id="creating-job-offers-collapseTwo" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingTwo" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>There are a few steps required to create a job offer. Some of the steps are optional, meaning you can choose whether to include them in your job offer. Here is a short description:</p>
                    <ul class="bulleted-list">
                        <li>Basic Information: The user is first asked to provide a short description of the job offer. Details such as the title, field, work address, and a few other pieces of information are required.</li>
                        <li>Job Details: The employer must provide a brief description of the job's nature, requirements, and the tasks involved.</li>
                        <li>Schedule and Additional Information: The next pages cover the schedule, salary, duration, mode of work, and any additional information.</li>
                        <li>Additional Requirements: Candidate requirements like sex, age, ethnicity, and country of origin are asked. This can be useful if the employer wants to hire someone from a particular minority group.</li>
                        <li>Questions and Interviews: On this page, the employer can add either text questions to the job offer or a video interview. It provides a set of tools for adding questions, such as text fields, multiple-choice questions, etc. The employer can also include a video interview, where questions appear on the screen as the candidate answers them. The video will be recorded, allowing the employer to watch or download it.</li>
                        <li>Exams: Finally, on this page, the employer can add online exams to the job offer. Candidates will need to complete these exams in order to apply for the job. The employer has the option to automatically accept candidates who have already earned a badge by completing the exam themselves, meaning they won't need to retake it. The employer can also require that the exam be passed before applying, regardless of whether the candidate has taken the exam before.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseThree" aria-expanded="false" aria-controls="creating-job-offers-collapseThree">
                    How do I prevent individuals that do not match my criteria to apply to my job offer?
                </button>
                </h2>
                <div id="creating-job-offers-collapseThree" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingThree" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p><p>Additional Requirements:</p> In this step, the employer can set various filters to specify candidate requirements, such as sex, age, ethnicity, country of origin, etc. These filters can be useful if the employer is seeking candidates from specific demographics, geography, age or minority groups.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseFour" aria-expanded="false" aria-controls="creating-job-offers-collapseFour">
                    How to send my job offer to someone who is not on WorkFrater?
                </button>
                </h2>
                <div id="creating-job-offers-collapseFour" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingFour" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>If you find an interesting candidate who does not have an account, you can send them the link to the job offer. You can set your job offer to allow candidates without an account to apply. They will be asked for basic information such as their name, age, and email address, and they will be able to apply for your job offer, as well as complete the interviews and online tests.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseFive" aria-expanded="false" aria-controls="creating-job-offers-collapseFive">
                    I simply want to test a candidate with the online tests on the site. I do not want to do a whole job offer. Can I do that?
                </button>
                </h2>
                <div id="creating-job-offers-collapseFive" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingFive" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, You might know a person who could be a very good candidate for a potential future job offer. You can still test him and assess his qualifications. You can create an exam template with a list of exams and interviews without needing to create a job offer.</p>
                    <p>Once created, a URL link will be provided to you. You can then send this link to your candidate. They will complete the online interviews and tests, and you will immediately receive the results, PDF reports, and the video after they finish.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseSix" aria-expanded="false" aria-controls="creating-job-offers-collapseSix">
                    What is the job offer board and how do I see it?
                </button>
                </h2>
                <div id="creating-job-offers-collapseSix" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingSix" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>The job offer board is where an employer can view the list of all candidates who have applied to a job offer. The board provides information about the candidacies and displays the following:</p>
                    <ul class="bulleted-list">
                        <li><b>List of Applications:</b> A list of all users who have applied to your job offer.</li>
                        <li><b>Results:</b> If you’ve added online tests to your job offer, this section will display the results for all candidates, shown as percentages.</li>
                        <li><b>Statistics:</b> This section provides various statistics about the exams, both globally and for each candidate. It will display the average score, duration of test completion, best candidate, worst candidate, and more.</li>
                        <li><b>Summary:</b> An AI-generated text summary of the statistics.</li>
                        <li><b>Videos:</b> This section displays the video tests and interviews of all your candidates. You can watch them directly or download them.</li>
                        <li><b>Documents:</b> This section allows you to download the PDF report for the job offer and for each individual who applied.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseSeven" aria-expanded="false" aria-controls="creating-job-offers-collapseSeven">
                    What is the individual candidate pdf?
                </button>
                </h2>
                <div id="creating-job-offers-collapseSeven" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingSeven" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>In the job offer board, the employer can download a candidate's PDF. The PDF contains several important pieces of information:</p>
                    <ul>
                        <li><b>Identity:</b> Profile picture, name, city, country, age, and ethnicity.</li>
                        <li><b>User Site Information:</b> Date of sign-up, number of jobs applied to, number of completed exams with results.</li>
                        <li><b>Test Results:</b> This section of the PDF displays the results and statistics for each test completed as part of the job offer.</li>
                    </ul>
                    <p>This pdf is available for each video of the tests of your candidate you buy.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseEight" aria-expanded="false" aria-controls="creating-job-offers-collapseEight">
                    What is the global job offer pdf?
                </button>
                </h2>
                <div id="creating-job-offers-collapseEight" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingEight" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>This PDF document displays global statistics and exam results for every candidate who has applied. It provides more details about:</p>
                    <ul>
                        <li><b>People Who Applied</b></li>
                        <li><b>Test Results</b></li>
                        <li><b>Statistics:</b> Average, median, highest, and lowest results.</li>
                    </ul>
                    <p>It also includes a more detailed AI-generated summary. <b>This pdf document is only available for gold and platinum account.</b></p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseNine" aria-expanded="false" aria-controls="creating-job-offers-collapseNine">
                    What are some tips to make sure that I select the right candidate?
                </button>
                </h2>
                <div id="creating-job-offers-collapseNine" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingNine" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>To ensure you select the right candidate, we recommend the following:</p>
                    <ul>
                        <li>Add video interviews to all your job offers and include as many questions as possible. The more questions you add to the interviews, the clearer your understanding of the candidate will be.</li>
                        <li>Use our suggested video interview questions in your job offer. We have a large database of pertinent questions, use as many as you can to assess your candidates.</li>
                        <li>Include a wide range of test assessments in your job offer, especially for STEM fields. The more tests your candidates complete, the better you will be able to assess their abilities.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseTen" aria-expanded="false" aria-controls="creating-job-offers-collapseTen">
                    Can I terminate a job offer if I found the right candidate?
                </button>
                </h2>
                <div id="creating-job-offers-collapseTen" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingTen" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, you can terminate your job offer at anytime by going in the settings of your job offer. Once you terminated it, the candidates that apply and were not chosen will have an automated message telling them that they were not chosen.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingEleven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseEleven" aria-expanded="false" aria-controls="creating-job-offers-collapseEleven">
                    Can I pause a job offer without terminating it?
                </button>
                </h2>
                <div id="creating-job-offers-collapseEleven" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingEleven" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, you can pause your job offer. In that case, only the people who have applied will remain in the job offer. They will still be able to do the list of exams that you requested for your job offer but other users will not be able to apply until you unpause it.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingTwelve">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseTwelve" aria-expanded="false" aria-controls="creating-job-offers-collapseTwelve">
                    Can I create a job offer on my mobile device?
                </button>
                </h2>
                <div id="creating-job-offers-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingTwelve" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, you can create job offers on any device and monitor who apply on your job offer via the job offer board.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingThirteen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseThirteen" aria-expanded="false" aria-controls="creating-job-offers-collapseThirteen">
                    Can I watch the video exams of my candidate on my mobile device?
                </button>
                </h2>
                <div id="creating-job-offers-collapseThirteen" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingThirteen" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>Yes, you can use any device to watch and download the videos of the exams and interviews of your candidates. You can also download the PDFs that come with the exam videos.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="creating-job-offers-headingForteen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseForteen" aria-expanded="false" aria-controls="creating-job-offers-collapseForteen">
                    Can I specifically prevent someone to apply to my job offer?
                </button>
                </h2>
                <div id="creating-job-offers-collapseForteen" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingForteen" data-bs-parent="#creating-job-offers">
                <div class="accordion-body">
                    <p>You cannot prevent someone who has not applied yet to your job offer to apply. However, once someone apply, and you do not want this person to see the status of the job offer or any other information, you can remove him from the job offer.</p>
                    <p>As an employer, if you block someone, he will not be able to see or apply to your job offer.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- BUYING EXAMS AND PDF OF CANDIDATES -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">BUYING EXAMS AND PDF OF CANDIDATES</h4>
        <div class="accordion" id="buying-exams-and-pdfs">
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseOne" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseOne">
                    After a candidate did an exam how can I watch it and see the results?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseOne" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingOne" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>There is many ways to do it, depending on your account type. If you have a normal employer account, you will have to buy the exam of every candidate that applied to your job offer or did it on his own account.  The video of the exam will also come with a pdf report with pertinent information like the results of each questions, the time it took to solve every questions, average, etc.</p>
                    <p>To buy the exam of your candidate on your job offer, simply go on your job offer page and go in the video section. The video of the exam will have the same exact name as your candidate. Simply click on it, and a new window will pop-up with a video frame, a button to download the video and another button to download the pdf report.</p>
                    <p>If you simply want to watch the exam of a candidate that he did on his own te get a badge, you simply need to go on his profile, click on tests, and you will see all the exams he did. Again, click on one of the video and a new window will popup with the same format as your job offer. You will be able to watch it, download it and download the pdf report.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseTwo" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseTwo">
                    What’s the basic price of an exam if I only have a standard employer account?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseTwo" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingTwo" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>If you have a normal account, the price to buy an exam is 4.99$. If you have a gold account, you will be able to download 20 exams per month. If you have a platinum account, you will have the possibility to download an unlimited amount of exams per month. All those come with the pdf report.</p>
                    <p>It is important to note that it is 4.99$ per exam and not per job offer. If you have 10 candidates who applied to your job offer and the 10 did the exams, you will have to buy each of these exams to see the video exam and see the results.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseThree" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseThree">
                    Can I be refund if I bought the video exam of a candidate and I am not interested by seeing it?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseThree" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingThree" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>No. Exam videos cannot be refund unless the video contains bugs or other external problems. In that case, you can contact our tech support or customer support and we can refund you.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseFour" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseFour">
                    Can I share the videos of the exams I bought on social Medias and elsewhere?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseFour" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingFour" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>No, these videos are exclusively for your own usage. You cannot share it publicly on social media or on any other settings than at your job. They contain the footage of an individual with his environment and many other personal information. Sharing it could lead to a lawsuit.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseFive" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseFive">
                    Can I store the videos and the PDFs of the exams and interviews of my job offer?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseFive" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingFive" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>Yes, you can store it on any device or cloud platform you want. However, you are not allowed to share it outside your company.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseSix" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseSix">
                    If I delete my job offer, will I still be able to see the videos of the exams and interviews I bought on that job offer?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseSix" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingSix" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>Yes, all videos you have bought will always be available on your video page. You can access your video page by clicking on your profile picture icon on the top right of the navigation bar. Unless you delete them, all the videos will always be available on your video page.</p>
                    <p>If you believe that some of the videos you bought are no longer available communicate with tech support and we will help you.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseSeven" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseSeven">
                    Will the video exams and the PDF reports that I bought be visible on other parts of the site or to other people?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseSeven" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingSeven" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>No. the videos and files you bought in your job offers exclusively belongs to you. No one else will have access to those videos.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="buying-exams-and-pdfs-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#buying-exams-and-pdfs-collapseEight" aria-expanded="false" aria-controls="buying-exams-and-pdfs-collapseEight">
                    In which languages are the exams and PDF reports available?
                </button>
                </h2>
                <div id="buying-exams-and-pdfs-collapseEight" class="accordion-collapse collapse" aria-labelledby="buying-exams-and-pdfs-headingEight" data-bs-parent="#buying-exams-and-pdfs">
                <div class="accordion-body">
                    <p>Currently, they are available only in English.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- AUTOMATIC VIDEO INTERVIEWS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">AUTOMATIC VIDEO INTERVIEWS</h4>
        <div class="accordion" id="automatic-video-interviews">
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseOne" aria-expanded="false" aria-controls="automatic-video-interviews-collapseOne">
                    What are video interviews on WorkFrater and how does it work? 
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseOne" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingOne" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>Video interviews are powerful tools allowing an employer to know in depth pertinent information about a candidate after he has read his resume and before interviewing him. While creating a job offer, an employer can add a video interview to his offer. Every user who apply to this job offer will have to take the video interview in order to apply successfully to the job offer.</p>
                    <p>The employer can add as many questions he wants to the video interview and he can add suggested questions from our site’s database. When the time come to do the video interview, during the job offer, the questions will appear on the screen and the candidate will have to answer them while the website is recording him.</p>
                    <p>The employer can set a range of time for each question. Per example, he can set that a certain question must be answered within 2 to 5 minutes. Before 2 minutes, the user will not be able to skip the question and after 5 minutes, the question will be skipped and the next question will appear.</p>
                    <p>After he finished the video interviews, the video will be available on your job offer page. A small preview will be available for you and if you want to see the full video, it will cost 4.99$. If you buy it, the video will be stored on your video page and you will be able to download it.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseTwo" aria-expanded="false" aria-controls="automatic-video-interviews-collapseTwo">
                    What a candidate needs in order to do the video interviews?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseTwo" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingTwo" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>A candidate needs a functioning webcam and a microphone in order to do a video interview. He also needs a stable internet connexion and a modern browser like chrome, Firefox or Safari. The video interviews does not require any plugin or extension to work.</p>
                    <p>If you allow your candidate to use a mobile phone to do his video interview, make sure that he allows his mobile browser gets access to his camera and microphone. </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseThree" aria-expanded="false" aria-controls="automatic-video-interviews-collapseThree">
                    What do you recommend to employer before creating a video interview for their job offer?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseThree" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingThree" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>We recommend a few things to employers in order for them to fully know the profiles of their candidate:</p>
                    <ul class="bulleted-list">
                        <li>Add a large number of questions: It will allow you to know more about your candidates.</li>
                        <li>Make your video interview global: Make sure that all the requirements that are needed for your new job offer will correspond to  questions in your video interview </li>
                        <li>Use our recommended questions: Our system will propose you questions to display according to you job offer. Our system will read your job offer and detect key words that match with pertinent questions. Use those proposed questions in addition to your own questions.</li>
                        <li>Do not hesitate to set-up many interview videos: An employer can setup more than one interview video per job offer. Separate your interview questions by themes to allow you to be organised in the assessment of your candidate. You could, per example, set-up , a video interview for technical questions, and another video interview for past experiences</li>
                        <li>Use many languages: If your job offer require the knowledge of many languages, do not hesitate to ask different questions in different languages to assess his comprehension of those languages </li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseFour" aria-expanded="false" aria-controls="automatic-video-interviews-collapseFour">
                    Where can I watch the video interviews after my candidates finished them?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseFour" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingFour" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>You can watch them directly on your job offer page by purchasing them for each candidate. The same videos will also be available on your video page alongside the exams. Even if you delete your job offer, your videos will be available on your video page.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseFive" aria-expanded="false" aria-controls="automatic-video-interviews-collapseFive">
                    Can I share the video interviews of my job offers publicly?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseFive" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingFive" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>You may only share the video interviews within the context of your job offer, such as with your teammates or superiors involved in the hiring process. Sharing these videos on social media or public video platforms is strictly prohibited. WorkFrater reserves the right to take legal action if these videos are shared publicly.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseSix" aria-expanded="false" aria-controls="automatic-video-interviews-collapseSix">
                    Can I watch the video interviews of my candidate via my mobile device?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseSix" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingSix" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>Yes, you can watch the video interviews and video tests of your candidates on your mobile phone without the need to download them. The job offer page includes a built-in video player, allowing you to view them directly on the page.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseSeven" aria-expanded="false" aria-controls="automatic-video-interviews-collapseSeven">
                    Is there a setting allowing me to forbid my candidate to use a mobile device to do a video interview?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseSeven" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingSeven" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>Yes, unlike online exams, video interviews can be done on desktop or with a mobile device. While setting up a video interview for your job offer, you can chose if the candidate can only use his pc or if he has the choice to do a mobile device. If you select only the PC option, the candidate will not be able to pass the video interview on a mobile device.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseEight" aria-expanded="false" aria-controls="automatic-video-interviews-collapseEight">
                    Can I put a time limit for each questions of the video interviews?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseEight" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingEight" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>Yes, you can set lower and upper time limits for each question. Candidates will not be able to skip the question until the lower time limit has passed, and once the upper time limit is reached, the question will be skipped automatically.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseNine" aria-expanded="false" aria-controls="automatic-video-interviews-collapseNine">
                    Can a candidate skip a question during a video interview?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseNine" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingNine" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>When setting up your video interviews, you have the option to specify whether a question can be skipped or not.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="automatic-video-interviews-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#automatic-video-interviews-collapseTen" aria-expanded="false" aria-controls="automatic-video-interviews-collapseTen">
                    Can I send a video interview to a candidate without making a job offer?
                </button>
                </h2>
                <div id="automatic-video-interviews-collapseTen" class="accordion-collapse collapse" aria-labelledby="automatic-video-interviews-headingTen" data-bs-parent="#automatic-video-interviews">
                <div class="accordion-body">
                    <p>Yes, you can create a video interview and share it with any candidate on the site. Even if the candidate does not have an account, you can send them a URL link to the video interview. When the candidate clicks the link, they will be prompted to enter basic information before proceeding with the video interview, just as if they were registered on the site. The completed video will then be available in your video section under the "Video Interview" tab.
                    </p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- EDUCATION ACCOUNTS AND ONLINE CLASSROOMS -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">EDUCATION ACCOUNTS AND ONLINE CLASSROOMS</h4>
        <div class="accordion" id="education-account-n-classrooms">
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseOne" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseOne">
                    What Are Online Classrooms on WorkFrater?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseOne" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingOne" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Online classrooms allow teachers to give online courses in a safe and intuitive way. Instead of using platforms like Zoom or Teams, which have very few options, they can use the powerful tools that WorkFrater offers to teach their classes. Here are the options that the platform offers to your school and teachers:</p>
                    <ul class="bulleted-list">
                        <li><b>Teach your students in a safe and focused manner:</b> While you are teaching using our online classrooms, the platform allows you to record the screen and webcam of every student. Afterwards, you can watch the videos of every student to make sure they are not navigating to forbidden sites or doing something else.</li>
                        <li><b>Monitor your students during class assignments and exams:</b> You can use the same recording functionality during exams and assignments. To make sure that your students do not communicate with each other, navigate to forbidden sites, or get answers elsewhere, you have the option to record both their screen and webcam. At the end of the assignments or tests, the videos of every student will be available, and you will be able to ensure they followed the instructions.</li>
                        <li><b>Create online tests directly on the platform:</b> Many schools distribute their exams and assignments in Word or PDF documents, which students must fill out in a different app and send back at the end. With WorkFrater, you can directly build a test or assignment that your students will be able to take in their online classroom. The questions can be text fields, multiple-choice questions, or associations. You can share the exam during an online class, or students can take it independently on the classroom page. Either way, their screen and webcam will be filmed while they complete the test or assignment.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTwo" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTwo">
                    Why should my school create an account on Workfrater?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseTwo" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTwo" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>There are many advantages to creating an account on this platform:</p>
                    <ul>
                        <li>Student Visibility: Potential employers will be able to visit the profile of your school to search for potential interns and job candidates. Your profile page will contain a list of all students who are looking for internships, making it easy for employers to find and contact them.</li>
                        <li>Online Classrooms: This platform offers online classrooms that allow your teachers to conduct classes with many useful functionalities. Your teacher can record the screen and webcam of all students during a lecture to prevent them from engaging in prohibited activities. Our online classrooms offer other advantages that you can explore here.</li>
                    </ul>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseThree" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseThree">
                    How can our students join the site and online classroom?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseThree" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingThree" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>our students simply need to create a user account on WorkFrater. They will then need to search for your school or educational institution and request to join it. Afterward, your teacher will be able to add them to their online classrooms. They will have access to the online classroom and will be able to attend courses and use other resources available in the online classroom.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFour" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFour">
                    How teachers can join my school or education institution?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseFour" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFour" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Your teachers, like your students, only need to create a user account to join your classroom. Afterward, they can search for your school and click the button to apply to become a teacher. You will receive a notification that they have requested to be a teacher at your school, and you will need to accept them.
                    </p>
                    <p>Once they are part of your school page, they can create online classrooms. They can follow the tutorial here to learn how to create and manage a classroom.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseFive" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseFive">
                    Can a student join an online classes without a webcam?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseFive" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingFive" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Teachers, while creating their online classrooms can decide if a student can join the online classroom without a webcam in the settings menu. If the teacher disable this functionality, the student will only be able to enter the waiting room but not the video call of the class.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSix" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSix">
                    Can a student join a classroom with a mobile device instead of a computer?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseSix" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSix" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Teachers also have the option, while creating their online classroom, to allow or disallow mobile devices from entering the classroom. If the teacher disables this option, students will only be able to enter the waiting room, but not the video call.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseSeven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseSeven">
                    How Can I record the webcam and screen of all the students during my lecture?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseSeven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingSeven" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Once the video call has started, you simply need to press the "Record" button. A window will pop up with all the options you need to record the screen of all the participants.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEight" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEight">
                    Where can i found the recorded videos of my students?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseEight" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEight" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Like other videos, they will appear on your videos page. Your videos page can be accessed by clicking your profile picture button at the top right of the navigation bar. On that page, click on the "Classroom" tab, and you will see all the recorded videos. As a teacher, all your student videos can also be accessed on your classroom page.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseNine" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseNine">
                    Can a participant share his screen during a class?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseNine" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingNine" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>Yes, a student or another participant can share their screen during a video call, just like on Zoom or Teams.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseTen" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseTen">
                    What part of the screen is recorded when I record the video of my lecture?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseTen" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingTen" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>By default, the site will record your video frame. When you share your screen during a lecture, it will record the shared screen. When a student or another participant shares their screen, their screen will also appear in the video.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="education-account-n-classrooms-headingEleven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#education-account-n-classrooms-collapseEleven" aria-expanded="false" aria-controls="education-account-n-classrooms-collapseEleven">
                    Can I add as many people I want in an online classroom?
                </button>
                </h2>
                <div id="education-account-n-classrooms-collapseEleven" class="accordion-collapse collapse" aria-labelledby="education-account-n-classrooms-headingEleven" data-bs-parent="#education-account-n-classrooms">
                <div class="accordion-body">
                    <p>The number of students you can add in a classroom and the number of classroom you can have is limited by your plan. We invite you to check our <a href="#">price ranges for our plans</a>.</p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- BECOMING AN ENTREPRENEUR ON THE PLATFORM -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">BECOMING AN ENTREPRENEUR ON THE PLATFORM</h4>
        <div class="accordion" id="becoming-an-entrepreneur">
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseOne" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseOne">
                    How to become an entrepreneur on the site?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseOne" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingOne" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>You simply need to create an individual (normal) account. On your profile page, there is a tab called "Entrepreneur." Initially, the tab will be empty, showing only a button to start your entrepreneurship project. Once you start your project, it will appear in your tab and on the Entrepreneurs page. Additionally, your project will become visible in the entrepreneurs' search engine.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwo" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwo">
                    Why should I share my entrepreneur project on WorkFrater?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseTwo" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwo" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>Sharing your entrepreneur project on WorkFrater gives you access to a dynamic platform designed to connect you with like-minded individuals, investors, and potential collaborators. By showcasing your project:</p>
                    <ul class="bulleted-list">
                        <li><b>Increase Visibility:</b> Your project will be visible to a global audience, enhancing your chances of gaining support and recognition.</li>
                        <li><b>Build Connections:</b> Use the platform's powerful search engine to find and network with entrepreneurs in your field or region. Entrepreneurs can be found according to their ethnicity, present location and type of projects.</li>
                        <li><b>Crowdfunding Opportunities:</b> Unlock funding options by allowing followers to support your project through donations or monthly contributions.</li>
                        <li><b>Professional Feedback:</b> Engage with a community that provides valuable insights and suggestions to refine your project.</li>
                        <li><b>Global Reach:</b> Gain exposure to users from diverse backgrounds, creating opportunities for cross-border collaborations.</li>
                    </ul>
                    <p>By sharing your project on WorkFrater, you will be part of a thriving entrepreneurial ecosystem tailored to help you succeed.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseThree" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseThree">
                    What are the steps to put my project on WorkFrater?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseThree" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingThree" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>There are just a few steps to publish your project on this platform:</p>
                    <ul>
                        <li><b>Create Your Project:</b> On your profile page, navigate to the "Entrepreneur" tab and click the button to create your project.</li>
                        <li><b>Fill Out the Form:</b> You’ll be provided with a simple form to complete with basic information about your project or company. This information will appear on your entrepreneur page and will also be used to generate questions for your video interview.</li>
                        <li><b>Video Interview:</b> Once the form is completed, you’ll participate in an automated interview using your webcam. A new window will open, and the video interview will begin. As the website records your responses, questions will be displayed at the bottom of the screen for you to answer.</li>
                        <li><b>Publish Your Project:</b> After completing the video interview, your project will be published, making it visible in search results and on the entrepreneur page.</li>
                        <li><b>Engage with Other Entrepreneurs:</b> Connect with like-minded entrepreneurs and grow your network by joining entrepreneur groups on WorkFrater.</li>
                        <li><b>Publish update videos:</b> Keep your audience engaged by posting videos on the progress of your  project</li>
                    </ul>
                    <p>By following these steps, you will showcase your project and build valuable connections within the entrepreneurial community.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFour" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFour">
                    What are the fields that I have to fill in the form?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseFour" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFour" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>You need to complete a few fields to ensure the website tailors a list of questions for your video interview and displays your project correctly in search results. Here are the fields you need to fill out:</p>
                    <ul class="bulleted-list">
                        <li><b>Name of the enterprise</b></li>
                        <li><b>Location</b> (city and country)</li>
                        <li><b>Personal informations</b></li>
                        <li><b>interests</b></li>
                        <li><b>Website</b> (if available)</li>
                        <li><b>Type of Project</b></li>
                        <li><b>Stage of development</b></li>
                        <li><b>Team</b> (number of members or roles)</li>
                        <li><b>Initial funds</b> (amount already secured)</li>
                        <li><b>Funds required</b> (amount needed for the next stage)</li>
                        <li><b>Expansion plans</b></li>
                    </ul>
                    <p>By providing this information, the website can generate meaningful questions during the video interview, that will help a global audience understand and connect with your project.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFive" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFive">
                    What are the questions that are asked during the video interview?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseFive" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFive" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>The video interview helps a global audience understand your project in an intuitive and straightforward way. It condenses the key elements of a standard business plan, making it easier to communicate the essence of your project effectively. These key points include:</p>
                    <ul>
                        <li><b>Executive Summary:</b> A brief overview of your project, its goals, and its unique value.</li>
                        <li><b>Business Description:</b> Details about your enterprise, including its mission, vision, and the problem it solves.</li>
                        <li><b>Market Analysis:</b> Insights into your target market, competition, and industry trends.</li>
                        <li><b>Organization and Management:</b> Information about your team, their roles, and their expertise.</li>
                        <li><b>Products or Services:</b> A description of what your project offers and its unique selling points.</li>
                        <li><b>Marketing and Sales Strategy:</b> Your plan for reaching your target audience and generating revenue.</li>
                        <li><b>Operational Plan:</b> How your project will function on a day-to-day basis.</li>
                        <li><b>Financial Plan:</b> Details about your funding needs, initial investments, and projected revenue.</li>
                        <li><b>Growth and Expansion Plans:</b> Your vision for scaling your project in the future.</li>
                    </ul>
                    <p>By addressing these points, the video interview ensures a comprehensive and engaging presentation of your project.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSix" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSix">
                    How will my project be visible to a large audience?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseSix" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSix" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>All projects will be visible on the entrepreneur page and in search results, provided they match the applied search filters. Projects that receive the most interaction—such as visits, views, and comments—will be prominently displayed at the top of search results and on the entrepreneur page.</p>
                    <p>Visitors and entrepreneurs searching for like-minded projects are more likely to notice your project if it aligns with their filters. Entrepreneurs often prefer connecting with others from the same country of origin or ethnicity within their cities.</p>
                    <p>Additionally, the algorithm for the “For You” section will prioritize displaying videos of entrepreneurs who share similar characteristics with the user, enhancing the chances of meaningful connections.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSeven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSeven">
                    What is the “for you” section on the entrepreneur page?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseSeven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSeven" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>The “For You” section will display entrepreneur project videos in a format similar to Tiktok or Instagram Reels. Users can swipe up to view the next video. Each video will showcase the entrepreneur’s name, their project, ethnicity, and country of origin.</p>
                    <p>The algorithm will prioritize displaying projects that closely align with the user’s own project or interests. Like on Tiktok, users can like and comment on videos. The more engagement a video receives, the more prominently it will be displayed to a larger audience, increasing its visibility and reach.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEight" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEight">
                    How to search for interesting project?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseEight" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEight" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>You can use the search engine on the entrepreneur page to find projects that interest you. The search engine offers a variety of filters to narrow down your results:</p>
                    <ul class="bulleted-list">
                        <li><b>Name of the entrepreneur</b></li>
                        <li><b>Name of the project</b></li>
                        <li><b>Ethnicity</b></li>
                        <li><b>Country of origin</b></li>
                        <li><b>Type of project</b></li>
                        <li><b>Location</b></li>
                    </ul>
                    <p>These filters make it easy to discover projects that align with your interests or specific criteria.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseNine" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseNine">
                    What type of projects aren’t allowed on the platform?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseNine" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingNine" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>Certain types of projects are not permitted on this platform. Projects related to the following topics are strictly prohibited:</p>
                    <ul>
                        <li><b>Cryptocurrency</b></li>
                        <li><b>Pornography</b></li>
                        <li><b>Gambling</b></li>
                        <li><b>Bars and clubs</b></li>
                        <li><b>Drugs</b></li>
                        <li><b>alcohol</b></li>
                    </ul>
                    <p>Promoting these types of projects will result in permanent banning from the platform. The platform maintains these restrictions to ensure a safe and professional environment for all users.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTen" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTen">
                    How can I use this platform to finance my project?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseTen" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTen" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>WorkFrater offers a simple and intuitive way to finance a project. Whether on the entrepreneur page, in the “For You” section, or the search results, users can easily click a button to support your project if they find it interesting. They have the option to make either a one-time payment or set up a monthly contribution to help fund your project. The platform allows MasterCard, Visa and PayPal as payment methods.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEleven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEleven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEleven">
                    How do I get paid with my project?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseEleven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEleven" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>The funds you raise through crowdfunding can be deposited into your PayPal account. At any time, you can click the "Deposit" button on your entrepreneur page to transfer a portion or the entire amount of the funds. A history of all your payments and transactions is available in the "Parameters" tab of your entrepreneur page.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwelve">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwelve" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwelve">
                    If I suspect that a project is fraudulent, can I report it?
                </button>
                </h2>
                <div id="becoming-an-entrepreneur-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwelve" data-bs-parent="#becoming-an-entrepreneur">
                <div class="accordion-body">
                    <p>Yes, if you come across a suspicious video while scrolling through the "For You" page or the search results, you can report it by clicking the report button. This button will provide you with several options to assist customer service in addressing the issue.
                    </p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- CONFIDENTIALITY, SAFETY AND PAYMENT -->
    <!-- <div class="mb-5 position-relative">
        <h3 class="mb-3">CONFIDENTIALITY, SAFETY AND PAYMENT</h4>
        <div class="accordion" id="confidentiality-safety-and-payment">
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseOne" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseOne">
                    Are my private financial information stored on the website?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseOne" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingOne" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>No, WorkFrater does not store your private financial information. We use Braintree, which stores your information on its own encrypted servers. WorkFrater does not store any of your financial details. Your credit card number, CVV, expiration date, and PayPal login credentials are all encrypted and  securely stored by the Braintree payment system.</p>
                    <p>The website only stores a copy of your bills in order to help you if there is a problem. Your bills do not contain your credit card or PayPal information.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseTwo" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseTwo">
                    What is Braintree?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseTwo" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingTwo" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>Braintree is the payment platform WorkFrater uses to process all the transactions on the site. It securely handles payments by supporting various methods, including credit and debit cards, PayPal, and other digital wallets. Braintree ensures that your financial information is encrypted and safely stored on their servers, providing a seamless and secure transaction experience for all users.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseThree" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseThree">
                    Where can I see my bills?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseThree" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingThree" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>By default, all your bills will be sent to you via email. You can disable this feature by going to the settings page in the bills section. In that same section, you can view a list of all your bills and transactions.</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseFour" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseFour">
                    What can I do if I cannot find a payment in the bills section?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseFour" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingFour" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>If you experience any issues with a payment, please contact customer support. We will respond to you promptly.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseFive" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseFive">
                    Are my messages and chats visible to the WorkFrater team?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseFive" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingFive" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>Your conversations are only visible to a specific number of people on our customer support team. They only access your messages in the event of a complaint, fraud, or any other type of irregularity.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseSix" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseSix">
                    If I delete my account, does all information related to my account disappear?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseSix" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingSix" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>All information related to your account will be deleted within 30 days after you permanently delete your account. This includes your profile information, messages, bills, and any other related data.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseSeven" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseSeven">
                    Can I view my bills on my mobile device?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseSeven" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingSeven" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>Yes, you can view your bills on the mobile version of our website and on our upcoming app as well. Additionally, you can download a PDF version of the bill directly to your mobile device.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingEight">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseEight" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseEight">
                    What informations are on my bills?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseEight" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingEight" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>Your bill contains several type of information:</p>
                    <p><b>Personal name or company:</b> first and last name or the name of a company</p>
                    <p><b>Email:</b> the email you entered during signing up</p>
                    <p><b>Date of transaction:</b> The date the was issued</p>
                    <p><b>Mode of payment:</b> credit card or PayPal</p>
                    <p><b>Product bought:</b> subscription, exam videos, interview videos, etc.</p>
                    <p><b>Amount:</b> the amount of the bill in USD</p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingNine">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseNine" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseNine">
                    Which currency is used on the site?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseNine" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingNine" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>WorkFrater uses the United States dollar (USD) for ease of payment and simplification.
                    </p>
                </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="confidentiality-safety-and-payment-headingTen">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#confidentiality-safety-and-payment-collapseTen" aria-expanded="false" aria-controls="confidentiality-safety-and-payment-collapseTen">
                    What happens if my payment method no longer has enough funds to pay for a monthly subscription?
                </button>
                </h2>
                <div id="confidentiality-safety-and-payment-collapseTen" class="accordion-collapse collapse" aria-labelledby="confidentiality-safety-and-payment-headingTen" data-bs-parent="#confidentiality-safety-and-payment">
                <div class="accordion-body">
                    <p>You will receive a warning via email and in your profile notifications. If the payment is not made within one month, your subscription will revert to the standard plan until the outstanding amount is paid.
                    </p>
                </div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
