<?php

use Illuminate\Support\Facades\Config;

$languages = Config::get('languages');
?>

<header id="workfrater-header" class="workfrater-header-before-login">
    <div class="container px-2">
        <div class="header-inner">
            <div class="header-left">
                <a class="navbar-brand" href="{{ route('index') }}"><img src="logos/header-logo2.png" alt="img" width="70" /></a>
            </div>
            <div class="header-center">
                <nav>
                    <div class="logo-box d-xl-none d-flex mb-5">
                        <img src="logos/header-logo2.png" alt="img" width="70" />
                        <div class="hamburger">
                            <div class="line line1"></div>
                            <div class="line line2"></div>
                            <div class="line line3"></div>
                        </div>
                    </div>
                    <div class="d-flex d-xl-none">
                        <div class="ms-auto">
                            @foreach ($languages as $lang => $language)
                                <a class="btn p-1 shadow-none" href="{{ route('lang.switch', $lang) }}">
                                    <img src="{{ URL::to('/') }}/images/flags/{{ $lang }}-flag.jpg"
                                        alt="" width="25" height="20">
                                </a>
                            @endforeach
                        </div>
                    </div>
                    <ul>
                        <li><a aria-current="page" href="/public/become-an-entrepreneur/">{{ getJsonLocalization('header', 'entrepreneur') }}</a></li>
                        <li><a href="/public/find-a-person">{{ getJsonLocalization('header', 'search') }}</a></li>
                        <li><a href="{{ route('viewjobs') }}">{{ getJsonLocalization('header', 'job offers') }}</a></li>
                        <li><a href="/public/search-an-online-test">{{ getJsonLocalization('header', 'exams') }}</a></li>
                        <li><a href="{{ route('interview') }}">{{ getJsonLocalization('header', 'interview') }}</a></li>
                        <li><a href="/public/virtual-classroom-conference">{{ getJsonLocalization('header', 'video-call/conference') }}</a></li>
                    </ul>

                    <div class="header-sidebar-btns d-xl-none d-block mt-4">
                        <a class="wf-btn wf-btn-outline-white me-1" href="{{ route('signup') }}"><span><i class="fa fa-user-plus" aria-hidden="true"></i></span>
                            {{ getJsonLocalization('header', 'sign up') }}
                        </a>
                        <a class="wf-btn wf-btn-secondary" href="{{ route('index') }}"><span><i class="fa fa-sign-in" aria-hidden="true"></i></span>
                            {{ getJsonLocalization('header', 'login') }}
                        </a>
                    </div>
                </nav>
            </div>
            <div class="header-right">
                <ul class="ms-auto d-xl-flex d-none">
                    <li><a href="{{ route('signup') }}"><span><i class="fa fa-user-plus" aria-hidden="true"></i></span>
                            {{ getJsonLocalization('header', 'sign up') }}
                        </a>
                    </li>
                    <!-- <li><a href="{{ route('index') }}"><span><i class="fa fa-sign-in" aria-hidden="true"></i></span>
                            {{ getJsonLocalization('header', 'login') }}</a></li>
                    <li> -->
                    <li>
                        <div class="d-flex gap-3">
                            @foreach ($languages as $lang => $language)
                                <a class="btn p-0 shadow-none" href="{{ route('lang.switch', $lang) }}">
                                    <img src="{{ URL::to('/') }}/images/flags/{{ $lang }}-flag.jpg" alt="" width="22" height="16">
                                </a>
                            @endforeach
                        </div>
                    </li>
                </ul>

                <div class="hamburger d-xl-none d-block ms-auto">
                    <div class="line line1"></div>
                    <div class="line line2"></div>
                    <div class="line line3"></div>
                </div>

            </div>
        </div>
    </div>
</header>

<script>
    $(document).ready(function() {

        $('#search_data').autocomplete({
            source: "/fetchMain",
            minLength: 1,
            select: function(event, ui) {
                $('#search_data').val(ui.item.value);
            }
        }).data('ui-autocomplete')._renderItem = function(ul, item) {
            return $("<li class='ui-autocomplete-row'></li>")
                .data("item.autocomplete", item)
                .append(item.label)
                .appendTo(ul);
        };

    });
</script>
