<?php
use App\Models\Follower;
use App\Models\Organisation;
use App\Models\Education;
use App\Models\Individual;
use App\Models\comments_adds;
use App\Models\PostLike;
$isMobile = preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src="js/jquery.min.js"></script>
    <meta http-equiv="Permissions-Policy" content="interest-cohort=()">
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <script type="text/javascript" src="js//home.js"></script>

    <script src="js//top_user_search.js" data-search-url="{{ route('searchResult.get') }}"></script>

</head>

<body>
    @include('homedesktopheader')

    <div class="container">
        <div class="profile-banner">
            <div class="cover-img-box">

                <img src="ProfileImages/Images/{{$CoverPic}}" alt="img" />
                <div class="update-img-btn" data-bs-toggle="modal" data-bs-target="#uploadcoverphots">
                    <i class="fa fa-camera" aria-hidden="true"></i>

                </div>
            </div>
            <div class="profile-banner-content">
                <div class="content-header">
                    <div class="inner1">
                        <div class="profile-img-and-info-box">
                            <div class="profile-img-box">

                                <img src="ProfileImages\Images\{{$userProfileData['profile_picture']}}" alt="img" />
                                <div class="update-img-btn" data-bs-toggle="modal" data-bs-target="#uploadiconpanel">
                                    <i class="fa fa-camera" aria-hidden="true"></i>

                                </div>
                            </div>
                            <div class="user-name-box">
                                <h3 class="user-name mb-0">
                                    <?php  echo $userProfileData['first_name'] . ' ' . $userProfileData['second_name']; ?>
                                </h3>
                                <div class="text-mini">{{$followerCount}} Followers | {{$followingCount}} Following
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="inner2" style="visibility: hidden;">
                        <a href="#" class="wf-btn wf-btn-outline-primary min-w-unset text-mini">Follow</a>
                        <a href="#" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-commenting"
                                aria-hidden="true"></i></a>
                        <a href="#" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-video-camera"
                                aria-hidden="true"></i></a>
                        <a href="#" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-ellipsis-v"
                                aria-hidden="true"></i></a>
                    </div>
                </div>
                <div class="content-footer">
                    <ul class="nav nav-tabs wf-nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="posts-tab" data-bs-toggle="tab" data-bs-target="#posts"
                                type="button" role="tab" aria-controls="posts" aria-selected="true">Posts</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="about-tab" data-bs-toggle="tab" data-bs-target="#about"
                                type="button" role="tab" aria-controls="about" aria-selected="false">About</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="followers-tab" data-bs-toggle="tab" data-bs-target="#followers"
                                type="button" role="tab" aria-controls="followers"
                                aria-selected="false">Followers</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="exams-tab" data-bs-toggle="tab" data-bs-target="#exams"
                                type="button" role="tab" aria-controls="exams" aria-selected="false">Exams</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="interviews-tab" data-bs-toggle="tab"
                                data-bs-target="#interviews" type="button" role="tab" aria-controls="interviews"
                                aria-selected="false">Interviews</button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="posts" role="tabpanel" aria-labelledby="posts-tab">
                <div class="px-lg-5 pt-5 py-lg-5">
                    <div class="commnader-grid">
                        <div class="inner2">
                            <div class="post-creater-block">
                                <div class="user-img-box">
                                    <img src="ProfileImages\Images\{{$userProfileData['profile_picture']}}" alt=""
                                        width="70" height="70" style="border-radius: 50%;">
                                </div>
                                <div class="editor-box">
                                    <input type="text"  autocomplete="off" id="messagepost" class="form-control"
                                        placeholder="Write your thoughts" data-bs-toggle="modal"
                                        data-bs-target="#addPostModel">
                                    <div class="row gx-2">
                                        <div class="col-3 col-sm-4 editor-box-action-col">
                                            <img src="logos/imgicon.png" class="me-1" height="18" alt="img" />
                                            <label style="font-size:12px;">
                                                Photo/video</label>
                                        </div>
                                        <div class="col-4 col-sm-4 editor-box-action-col">
                                            <img src="logos/person.png" class="me-1" height="18" alt="img" />
                                            <label style="font-size:12px">
                                                Tag friends</label>
                                        </div>
                                        <div class="col-5 col-sm-4 editor-box-action-col">
                                            <img src="logos/smilly.png" class="me-1" height="18" alt="img" />
                                            <label style="font-size:12px;">
                                                Feeling/ Activity</label>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="posts-container">
                                @foreach ($UserPostData as $userpostdata)
                                                                <div class="single-post mb-3">
                                                                    <div class="profile-avatar-box p-0 border-0">
                                                                        <div class="img-box">
                                                                            <img class="user-img"
                                                                                src="ProfileImages\Images\{{$userProfileData['profile_picture']}}"
                                                                                alt="img">
                                                                        </div>
                                                                        <div class="user-info-box">
                                                                            <h4 class="fw-bold mb-1">
                                                                                <?php    echo $userProfileData['first_name'] . ' ' . $userProfileData['second_name']; ?>
                                                                            </h4>
                                                                            <p class="mb-0 text-mini">Time: {{$userpostdata['created_at']}}</p>
                                                                        </div>
                                                                    </div>
                                                                    <div class="post-bottom-content">
                                                                        <div class="post-description">
                                                                            <p>{{$userpostdata['PostText']}}</p>
                                                                        </div>
                                                                        <div class="post-image-box post-image-box2" data-bs-toggle="modal"
                                                                            data-bs-target="#post-images-modal2<?php    echo $userpostdata['id'];?>">
                                                                            <?php
                                    $imageArraySize = 0;
                                    $path = public_path("PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName']);
                                    try {
                                        $files = array_slice(scandir($path), 2);
                                        $imageArraySize = count($files);
                                    } catch (Exception $e) {

                                    }

                                    if ($imageArraySize == 1) {
                                        $postImgeUrl = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[0];
                                                                                                                  ?>
                                                                            <div>
                                                                                <img src="{{$postImgeUrl}}" alt="post-img">
                                                                            </div>
                                                                            <?php
                                    } else if ($imageArraySize == 2) {
                                        $postImgeUrl1 = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[0];
                                        $postImgeUrl2 = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[1];
                                                                                                                 ?>
                                                                            <div>
                                                                                <img src="{{$postImgeUrl1}}" alt="post-img">
                                                                            </div>
                                                                            <div>
                                                                                <img src="{{$postImgeUrl2}}" alt="post-img">
                                                                            </div>
                                                                            <?php
                                        } else if ($imageArraySize > 2) {

                                            $postImge = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[0];
                                            $postImgeUrl2 = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[1];
                                                                                                                  ?>
                                                                            <div>
                                                                                <img src="{{$postImge}}" alt="post-img">

                                                                            </div>
                                                                            <div class="img-count">+<?php            echo $imageArraySize - 2; ?> </div>
                                                                            <div>
                                                                                <img src="{{$postImgeUrl2}}" alt="post-img">

                                                                            </div>

                                                                            <?php

                                        }
                                                                                                                  ?>


                                                                        </div>
                                                                        <!-- post images modal for 2 images -->
                                                                        <div class="modal fade"
                                                                            id="post-images-modal2<?php    echo $userpostdata['id'];?>" tabindex="-1"
                                                                            aria-labelledby="post-images-modalLabel" aria-hidden="true">
                                                                            <div
                                                                                class="modal-dialog modal-dialog-centered modal-lg ui-draggable ui-draggable-handle">
                                                                                <div class="modal-content bg-dark ui-resizable">
                                                                                    <div class="modal-header border-0 pb-0">
                                                                                        <button type="button" style="filter: contrast(0);"
                                                                                            class="btn-close" data-bs-dismiss="modal"
                                                                                            aria-label="Close"></button>
                                                                                    </div>
                                                                                    <div class="modal-body">
                                                                                        <div id="post-images-carousel2<?php    echo $userpostdata['id'];?>"
                                                                                            data-interval="false" class="carousel slide pointer-event"
                                                                                            data-bs-ride="carousel">
                                                                                            <div class="carousel-inner" style="text-align:center;">
                                                                                                <?php
                                    if (empty($files) == false) {
                                        $imgCount = 0;
                                        foreach ($files as $imgURL) {
                                            $postImgeUrl = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $imgURL;
                                            if ($imgCount == 0) {
                                                $imgCount = $imgCount + 1;
                                                                                                                                    ?>
                                                                                                <div class="carousel-item active">
                                                                                                    <img src="{{$postImgeUrl}}" alt="post-img">
                                                                                                </div>
                                                                                                <?php
                                            } else {
                                                                                                                                    ?>
                                                                                                <div class="carousel-item">
                                                                                                    <img src="{{$postImgeUrl}}" alt="post-img">
                                                                                                </div>
                                                                                                <?php

                                            }
                                                                                                                                ?>

                                                                                                <?php
                                        }
                                    }
                                                                                                                                 ?>


                                                                                            </div>
                                                                                            <button class="carousel-control-prev" type="button"
                                                                                                data-bs-target="#post-images-carousel2<?php    echo $userpostdata['id'];?>"
                                                                                                data-bs-slide="prev">
                                                                                                <span class="carousel-control-prev-icon"
                                                                                                    aria-hidden="true"></span>
                                                                                                <span class="visually-hidden">Previous</span>
                                                                                            </button>
                                                                                            <button class="carousel-control-next" type="button"
                                                                                                data-bs-target="#post-images-carousel2<?php    echo $userpostdata['id'];?>"
                                                                                                data-bs-slide="next">
                                                                                                <span class="carousel-control-next-icon"
                                                                                                    aria-hidden="true"></span>
                                                                                                <span class="visually-hidden">Next</span>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="ui-resizable-handle ui-resizable-e"
                                                                                        style="z-index: 90;"></div>
                                                                                    <div class="ui-resizable-handle ui-resizable-s"
                                                                                        style="z-index: 90;"></div>
                                                                                    <div class="ui-resizable-handle ui-resizable-se ui-icon ui-icon-gripsmall-diagonal-se"
                                                                                        style="z-index: 90;"></div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <!-- post images modal end -->

                                                                        <div class="post-actions">
                                                                            <div class="post-like-action">
                                                                                <?php
                                    $LikeInfo = "";
                                    $result4 = PostLike::where([['post_id', $userpostdata['created_at']], ['liker_email', $userProfileData['email_id']]])->get();
                                    if (count($result4) > 0) {
                                        foreach ($result4 as $roww) {
                                            $LikeInfo = $roww["like_unlike"];
                                        }
                                    }
                                    $likeCount = PostLike::where('post_id', '=', $userpostdata['created_at'])->get();
                                    $likeCcount = $likeCount->count();
                                    $linkeCC = 0;
                                    $showK = FALSE;
                                    if ($likeCcount > 1000) {
                                        $showK = TRUE;
                                        $moduleValue = $likeCcount % 100;
                                        $fristValue = $likeCcount / 100;
                                        $linkeCC = $fristValu . '.' . $moduleValue . 'K';
                                    } else {
                                        $linkeCC = $likeCcount . '';
                                    }

                                    if ($LikeInfo == 'Like') {

                                                                                                                     ?>

                                                                                <span class="cursor-pointer"><i class="fa fa-thumbs-up"
                                                                                        id="likeSymble<?php        echo $userpostdata['created_at']; ?>"
                                                                                        style="font-size:24px"
                                                                                        onclick="LikeFunction('<?php        echo $userpostdata['created_at']; ?>');"></i>
                                                                                </span>
                                                                                <span class="ms-2 text-mini"
                                                                                    id="likeCounting<?php        echo $userpostdata['created_at']; ?>">{{$linkeCC}}</span>
                                                                                <?php
                                    } else {
                                                                                                                    ?>
                                                                                <span class="cursor-pointer"><i class="fa fa-thumbs-o-up"
                                                                                        id="likeSymble<?php        echo $userpostdata['created_at']; ?>"
                                                                                        style="font-size:24px"
                                                                                        onclick="LikeFunction('<?php        echo $userpostdata['created_at']; ?>');"
                                                                                        data-bs-toggle="tooltip" title="Like"
                                                                                        aria-hidden="true"></i></span>
                                                                                <span class="ms-2 text-mini"
                                                                                    id="likeCounting<?php        echo $userpostdata['created_at']; ?>">{{$linkeCC}}</span>
                                                                                <?php
                                    }
                                    $result6 = comments_adds::where('post_id', $userpostdata['created_at'])->orderBy('id', 'DESC')->get();
                                    $commentCount = "";
                                    if (count($result6) < 10) {
                                        if (count($result6) == 0) {
                                            $commentCount = count($result6);
                                        } else {
                                            $commentCount = "0" . count($result6);
                                        }
                                    } else {
                                        $commentCount = count($result6);
                                    }

                                                                                                                    ?>
                                                                            </div>
                                                                            <div class="post-comments-action ms-auto text-mini">
                                                                                <a class="text-decoration-none cursor-pointer text-secondary"
                                                                                    data-bs-toggle="modal"
                                                                                    data-bs-target="#commentsModel<?php    echo $userpostdata['id'];?>">
                                                                                    {{$commentCount}} Comments</a>
                                                                            </div>
                                                                        </div>

                                                                        <!-- comments modal -->


                                                                        <!-- Modal -->
                                                                        <div class="modal fade" id="commentsModel<?php    echo $userpostdata['id'];?>"
                                                                            tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                            <div class="modal-dialog modal-dialog-centered">
                                                                                <div class="modal-content">
                                                                                    <div class="modal-header">
                                                                                        <h5 class="modal-title" id="exampleModalLabel">
                                                                                            {{$commentCount}} Comments
                                                                                        </h5>
                                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                                            aria-label="Close"></button>
                                                                                    </div>
                                                                                    <div class="modal-body">
                                                                                        <div class="all-comments">
                                                                                            <?php
                                    $result6 = comments_adds::where('post_id', $userpostdata['created_at'])->orderBy('id', 'DESC')->get();
                                    if (count($result6) > 0) {
                                        foreach ($result6 as $roww) {
                                            $commentsTxt = $roww["comments_txt"];
                                            $liker_Email = $roww["liker_email"];
                                            $comments_date_time = $roww["created_at"];
                                            $profile_image_liker = "";
                                            $fullNameShow = "";
                                            $result7 = Education::where('email_id', $liker_Email)->get();
                                            if (count($result7) > 0) {
                                                foreach ($result7 as $roww) {
                                                    $profile_image_liker = $roww["profile_picture"];
                                                    $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                }
                                            } else {
                                                $result7 = Individual::where('email_id', $liker_Email)->get();
                                                if (count($result7) > 0) {
                                                    foreach ($result7 as $roww) {
                                                        $profile_image_liker = $roww["profile_picture"];
                                                        $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                    }
                                                } else {


                                                    $result7 = Organisation::where('email_id', $liker_Email)->get();
                                                    if (count($result7) > 0) {
                                                        foreach ($result7 as $roww) {
                                                            $profile_image_liker = $roww["profile_picture"];
                                                            $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                        }
                                                    }
                                                }
                                            }

                                                                                                                                      ?>

                                                                                            <div class="single-commnet">
                                                                                                <div class="user-img">
                                                                                                    <img src="ProfileImages/Images/{{ $profile_image_liker}}"
                                                                                                        class="img-circle">
                                                                                                </div>
                                                                                                <div class="commnets-content">
                                                                                                    <div class="commnet-content-header">
                                                                                                        <div class="user-name">{{$fullNameShow}} </div>
                                                                                                        <div class="comment-date">
                                                                                                            {{ $comments_date_time}}
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div class="commnet-text">{{$commentsTxt}}</div>
                                                                                                </div>
                                                                                            </div>
                                                                                            <?php
                                        }
                                    }

                                                                                                                            ?>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="modal-footer">
                                                                                        <div class="commnet-writing-area m-0 w-100">
                                                                                            <div class="inner1">
                                                                                                <input type="text" autocomplete="off"
                                                                                                    id="commentsBox<?php    echo $userpostdata['created_at']; ?>"
                                                                                                    class="form-control" placeholder="Write comment">
                                                                                            </div>
                                                                                            <div class="inner2">
                                                                                                <button class="wf-btn wf-btn-primary" type="button"
                                                                                                    onclick="addComments('<?php    echo $userpostdata['created_at']; ?>');">Post</button>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                @endforeach
                                {{$UserPostData->links()}}
                            </div>

                        </div>
                        <div class="inner3 d-lg-block d-none">
                            <div class="white-box mb-3">
                                <h6 class="mb-3 fw-bold">Suggestions</h6>
                                <?php
foreach ($SuggestionsData as $dataArray) {

    $isFollowe = Follower::where([['email_id', '=', $dataArray['email_id']], ['follower_email_id', '=', $userProfileData['email_id']]])->get();
    $isFolloww = 'Follow';
    if (count($isFollowe) > 0) {
        $isFolloww = 'UnFollow';
    } else {
        $isFolloww = 'Follow';
    }


                                     ?>
                                <div class="profile-avatar-box align-items-start mb-2">
                                    <div class="img-box" style="position: relative; display: inline-block;">
                                        <img class="user-img"
                                            src="ProfileImages/Images/<?php    echo $dataArray['ProfilePic']; ?>" alt=""
                                            id="profile_img:<?php    echo $dataArray['email_id']; ?>" title="Offline"
                                            style="border-radius: 50%; width: 100px; height: 65px;">
                                        <div class="status-circle" id="islive:<?php    echo $dataArray['email_id']; ?>"
                                            style="position: absolute; top: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background-color:red;">
                                        </div>
                                    </div>
                                    <div class="user-info-box">
                                        <h6 class="fw-bold mb-0 text-capitalize">
                                            <a class="text-primary no-decoration d-block mb-2 cursor-pointer"
                                                href="{{ route('UserProfile') }}?profileUserEmailID=<?php    echo $dataArray['email_id']; ?>"><?php    echo $dataArray['FullName'];?></a>
                                            <div class="text-mini"><?php    echo $dataArray['AccountType'];?> (<span
                                                    id="countFollow<?php    echo $dataArray['email_id']; ?>"><?php    echo $dataArray['FollowCount'];?>
                                                </span>Followers)</div>
                                        </h6>
                                        <p class="mb-0 text-mini"><?php    echo $dataArray['CityCountry'];?></p>
                                        <p class="mb-0 text-mini text-start">
                                            <i class="fa fa-video-camera" aria-hidden="true"></i>
                                            <a class="text-success no-decoration fw-bold" href="javascript:void(0);"
                                                style="color:blue"
                                                onclick="OpenPeerToPeerVideoChatRoom('<?php    echo $userProfileData['first_name'] . '  ' . $userProfileData['second_name'];?>','<?php    echo $userProfileData['profile_picture'];?>','<?php    echo $dataArray['FullName'];?>','<?php    echo $dataArray['ProfilePic'];?>','<?php    echo $dataArray['email_id'];?>');"
                                                class="wf-btn wf-btn-primary min-w-unset">Video Call</a>
                                        </p>
                                        <p class="mb-0 text-mini text-start">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-chat-fill" viewBox="0 0 16 16">
                                                <path
                                                    d="M8 15c4.418 0 8-3.134 8-7s-3.582-7-8-7-8 3.134-8 7c0 1.76.743 3.37 1.97 4.6-.097 1.016-.417 2.13-.771 2.966-.079.186.074.394.273.362 2.256-.37 3.597-.938 4.18-1.234A9 9 0 0 0 8 15" />
                                            </svg>
                                            <a class="text-success no-decoration fw-bold" href="javascript:void(0);"
                                                style="color:blue"
                                                onclick="popupChat('<?php    echo $dataArray['email_id']; ?>','<?php    echo $dataArray['ProfilePic'];?>','<?php    echo $dataArray['FullName'] ?>');">Start
                                                Chat</a>
                                        </p>
                                        <p class="mb-0 text-mini text-end">
                                            <a class="text-secondary no-decoration fw-bold" href="javascript:void(0);"
                                                id="followLink<?php    echo $dataArray['email_id']; ?>"
                                                onclick="addFollows('<?php    echo $dataArray['email_id']; ?>');">{{$isFolloww}}</a>
                                        </p>
                                    </div>
                                </div>
                                <?php
}
                                    ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="about" role="tabpanel" aria-labelledby="about-tab">
                <div class="px-lg-5 pt-5 py-lg-5">
                    <div class="commnader-grid">
                        <div class="inner1">
                            <div class="white-box mb-3">


                                <h6 class="fw-bold mb-3">About Organization</h6>

                                <div class="mb-4">
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-industry" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box">Enterprise name: <span class="text-grey text-mini">
                                                {{ $userProfileData['entreprise_name'] }} </span></div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-building-o" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box">Org Structure: <span class="text-grey text-mini">
                                                {{ $userProfileData['org_structure'] }} </span></div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-flag" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box">Org Country: <span
                                                class="text-grey text-mini">{{ $userProfileData['country_org'] }}</span>
                                        </div>
                                    </div>

                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-address-card" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box">Civic Address: <span
                                                class="text-grey text-mini">{{ $userProfileData['civic_adress'] }}</span>
                                        </div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-calendar" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box">Registration Date: <span
                                                class="text-grey text-mini">{{ $userProfileData['organization_reg_date'] }}</span>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="inner2">
                            <!-- <div class="white-box mb-3">
                                    <h4 class="mb-3"></h4>

                                </div> -->
                            <div class="white-box mb-3">
                                <div class="mb-4">
                                    <h6 class="fw-bold mb-3">Overview</h6>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-envelope" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box text-secondary">Email: <span
                                                class="text-primary">{{$userProfileData['email_id']}}</span></div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-envelope" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box text-secondary">Organization Email: <span
                                                class="text-primary">{{$userProfileData['organization_email']}}</span>
                                        </div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">

                                            <i class="fa fa-globe" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box text-secondary">Company Website: <span
                                                class="text-primary">{{$userProfileData['entreprise_web_url']}}</span>
                                        </div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-phone" aria-hidden="true"></i>
                                        </div>

                                        <div class="text-box text-secondary">Phone: <span
                                                class="text-primary">{{$userProfileData['phone_number']}}</span></div>
                                    </div>
                                    <div class="icon-bar pb-2 mb-2 border-bottom" style="visibility: hidden;">
                                        <div class="icon-box text-secondary">
                                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                                        </div>
                                        <div class="text-box text-secondary">Address: <span
                                                class="text-primary">{{$userProfileData['full_address']}}</span></div>
                                    </div>
                                </div>
                                <div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="followers" role="tabpanel" aria-labelledby="followers-tab">
                <div class="px-lg-5 pt-5 py-lg-5">
                    <div class="commnader-grid">
                        <div class="inner2">
                            <div class="white-box">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="myFollowers-tab" data-bs-toggle="tab"
                                            data-bs-target="#myFollowers" type="button" role="tab"
                                            aria-controls="myFollowers" aria-selected="true">Followers<span
                                                class="text-mini ms-2 p-1 px-2 rounded-large bg-primary text-white fw-bold">{{$followerCount}}</span></button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="myFollowings-tab" data-bs-toggle="tab"
                                            data-bs-target="#myFollowings" type="button" role="tab"
                                            aria-controls="myFollowings" aria-selected="false">Following<span
                                                class="text-mini ms-2 p-1 px-2 rounded-large bg-primary text-white fw-bold">{{$followingCount}}</span></button>
                                    </li>
                                </ul>
                                <div class="tab-content pt-3" id="myTabContent">
                                    <div class="tab-pane fade show active" id="myFollowers" role="tabpanel"
                                        aria-labelledby="myFollowers-tab">
                                        <div class="row gx-md-3 gy-3">
                                            @foreach ($followerData as $followerPerson)
                                                @if(strlen($followerPerson['email_id']) > 0)

                                                    <div class="col-md-6 col-lg-4"
                                                        id="unfollowUser<?php        echo $followerPerson['email_id'];?>">
                                                        <div class="profile-avatar-box align-items-start mb-0">
                                                            <div class="img-box">
                                                                <img class="user-img"
                                                                    src="ProfileImages/Images/{{$followerPerson['ProfilePic']}}"
                                                                    alt="" name="profile_img" id="profile_img"
                                                                    style="border-radius: 50%;">
                                                            </div>
                                                            <div class="user-info-box">
                                                                <h6 class="fw-bold mb-0 text-capitalize">
                                                                    <a
                                                                        class="text-primary no-decoration d-block mb-2 cursor-pointer">{{$followerPerson['FullName']}}</a>
                                                                    <div class="text-mini">{{$followerPerson['AccountType']}}
                                                                        (<span
                                                                            id="countFollowaamir@gmail.com">{{$followerPerson['FollowCount']}}
                                                                        </span>Followers)</div>
                                                                </h6>
                                                                <p class="mb-0 text-mini">{{$followerPerson['CityCountry']}}</p>
                                                                <p class="mb-0 text-mini text-start">
                                                                    <a class="text-success no-decoration fw-bold"
                                                                        href="javascript:void(0);" style="color:blue"
                                                                        onclick="popupChat('<?php        echo $followerPerson['email_id']; ?>','<?php        echo $followerPerson['ProfilePic'];?>','<?php        echo $followerPerson['FullName'] ?>')">Start
                                                                        Chat</a>
                                                                </p>
                                                                <p class="mb-0 text-mini text-end">
                                                                    <a class="text-secondary no-decoration fw-bold"
                                                                        href="javascript:void(0);"
                                                                        onclick="UnaddFollows('<?php        echo $followerPerson['email_id']; ?>');">UnFollow</a>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                        <div class="mt-8">
                                            {{ $followerData->withPath(url()->current())->links() }}
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="myFollowings" role="tabpanel"
                                        aria-labelledby="myFollowings-tab">
                                        <div class="row gx-md-3 gy-3">

                                            @foreach ($followingData as $followingPerson)
                                                @if(strlen($followingPerson['email_id']) > 0)

                                                    <div class="col-md-4">
                                                        <div class="profile-avatar-box align-items-start mb-0">
                                                            <div class="img-box">
                                                                <img class="user-img"
                                                                    src="ProfileImages/Images/{{$followingPerson['ProfilePic']}}"
                                                                    alt="" name="profile_img" id="profile_img"
                                                                    style="border-radius: 50%;">
                                                            </div>
                                                            <div class="user-info-box">
                                                                <h6 class="fw-bold mb-0 text-capitalize">
                                                                    <a
                                                                        class="text-primary no-decoration d-block mb-2 cursor-pointer">{{$followingPerson['FullName']}}</a>
                                                                    <div class="text-mini">{{$followingPerson['AccountType']}}
                                                                        (<span
                                                                            id="countFollowaamir@gmail.com">{{$followingPerson['FollowCount']}}</span>Followers)
                                                                    </div>
                                                                </h6>
                                                                <p class="mb-0 text-mini">{{$followingPerson['CityCountry']}}
                                                                </p>
                                                                <p class="mb-0 text-mini text-start">
                                                                    <a class="text-success no-decoration fw-bold"
                                                                        href="javascript:void(0);" style="color:blue"
                                                                        onclick="popupChat('<?php        echo $followingPerson['email_id']; ?>','<?php        echo $followingPerson['ProfilePic'];?>','<?php        echo $followingPerson['FullName'] ?>')">Start
                                                                        Chat</a>
                                                                </p>
                                                                <p class="mb-0 text-mini text-end" style=" visibility: hidden">
                                                                    <a class="text-secondary no-decoration fw-bold"
                                                                        href="javascript:void(0);">Unfollow</a>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach

                                        </div>
                                        <div class="mt-8">
                                            {{ $followingData->withPath(url()->current())->links() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="exams" role="tabpanel" aria-labelledby="exams-tab">
                <div class="px-lg-5 pt-5 py-lg-5">
                    <div class="commnader-grid">
                        <div class="inner2">
                            <div class="white-box">
                                <div class="row gy-4">
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <div
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="box-rounded-50px mb-2">
                                                    <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                </div>
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>React Javascript</b></div>
                                                </div>
                                                <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                    <div class="col-6">Level 1</div>
                                                    <div class="col-6 text-end">Status <span
                                                            class="text-mini text-success">Completed</span></div>
                                                </div>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span
                                                            class="me-2"><i class="fa fa-play"
                                                                aria-hidden="true"></i></span>Play</a>
                                                    <a href="#"
                                                        class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="mt-5">
                                    <nav aria-label="Page navigation example">
                                        <ul class="pagination wf-pagination w-fit-content mx-auto">
                                            <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                            </li>
                                            <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                                            <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="interviews" role="tabpanel" aria-labelledby="interviews-tab">
                <div class="px-lg-5 pt-5 py-lg-5">
                    <div class="commnader-grid">
                        <div class="inner2">
                            <div class="white-box mb-3">
                                <div class="row gy-4">
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-xxl-3">
                                        <a href="#"
                                            class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                            <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                            <div class="p-3">
                                                <div class="d-flex flex-wrap justify-content-between">
                                                    <div><b>John Doe</b></div>
                                                    <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                </div>
                                                <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                    <div class="col-5"><b>Views:</b> <span
                                                            class="text-secondary text-mini">100k</span></div>
                                                    <div class="col-7 text-end"><b>Previews:</b> <span
                                                            class="text-secondary text-mini">22.3k</span></div>
                                                </div>
                                                <div><b>Type:</b> <span class="text-secondary text-mini">Automatic
                                                        interview</span></div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="mt-5">
                                    <nav aria-label="Page navigation example">
                                        <ul class="pagination wf-pagination w-fit-content mx-auto">
                                            <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                            </li>
                                            <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                                            <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- Add Profile Picutre Modal..................................................... -->
    <div id="uploadiconpanel" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{ getJsonLocalization('home', 'Add a new profile picture') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-5">
                        <img src="logos//logo1.png" alt="" width="100">
                    </div>
                    <div class="text-center mb-4">
                        <img src="ProfileImages\Images\{{$userProfileData['profile_picture']}}" alt="img" width="100"
                            height="100" style="border-radius: 50%;" id="updateProfileImage"
                            name="updateProfileImage" />
                    </div>
                    <form method="POST" action="{{route('UpdateProfileImageFromOldImages')}}"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" id="imageName" name="imageName"></input>

                        <div style="display:none; justify-content: center;" id="confirmUploadFromOld">
                            <div>
                                <button type="submit"
                                    class="wf-btn wf-btn-primary">{{ getJsonLocalization('home', 'Confirm Upload') }}</button>
                            </div>


                        </div><br>
                    </form>
                    <form method="POST" action="{{route('uploadUpdatedProfile') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="row my-3" style="display:none;" id="confirmUpload">
                            <div class="col-sm-12 text-center"> <button type="submit"
                                    class="wf-btn wf-btn-primary">{{ getJsonLocalization('home', 'Confirm Upload') }}</button>
                            </div>
                        </div>
                        <div>
                            <input value="Upload" type="file" accept=".png,.jpg,.jpeg" class="form-control"
                                id="customFile" name="customFile" onchange="PreviewImagetOnChange();" />
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <div class="row w-100 g-0">
                        <div class="col-6">
                            <button type="button" data-dismiss="modal" onclick="cancelProfilePicUpdateDialog();"
                                class="wf-btn wf-btn-secondary">{{ getJsonLocalization('home', 'Cancel') }}</button>

                        </div>
                        <div class="col-6 text-end"> <button type="button" class="wf-btn wf-btn-secondary"
                                data-bs-toggle="modal"
                                data-bs-target="#previousImages">{{ getJsonLocalization('home', 'Previous Pictures') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Profile Picutre Modal..................................................... -->
    <!-- Previous Profile Pictures Modal............................................. -->
    <div id="previousImages" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="width:40%;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{ getJsonLocalization('home', 'Previous profiles pictures') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <img src="logos//logo1.png" alt="" width="100">
                    </div>
                    <div class="text-center">
                        <?php
foreach ($oldProfilePictures as $rowInd) {
                         ?>
                        <img src="ProfileImages/Images/<?php    echo $rowInd['image_name']; ?>" alt="" width="120"
                            height="120" style="border-radius: 50%;"
                            onclick="selectOldProfileImage('<?php    echo $rowInd['image_name']; ?>');">
                        <?php
}
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Previous Profile Pictures Modal............................................. -->


    <!-- Add CoverPhotos Picutre Modal..................................................... -->
    <div id="uploadcoverphots" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{ getJsonLocalization('home', 'Add a new Cover picture') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-5">
                        <img src="logos//logo1.png" alt="" width="100">
                    </div>
                    <div class="text-center mb-4">
                        <img src="ProfileImages/Images/{{$CoverPic}}" alt="img" width="500" height="300"
                            id="updateCoverImage" name="updateCoverImage" />
                    </div>
                    <div class="text-danger" id="coverImageSizeMessage" style="display:none;">
                        <b> Cover Image Should be less then 600 Pixel In Width<b>
                    </div>

                    <form method="POST" action="{{route('uploadCoverPhoto') }}" enctype="multipart/form-data">
                        @csrf


                        <div>
                            <input value="Upload" type="file" accept=".png,.jpg,.jpeg" class="form-control"
                                id="customCoverFile" name="customCoverFile" onchange="PreviewCoverImagetOnChange();" />
                        </div>

                </div>
                <div class="modal-footer">
                    <div class="row w-100 g-0">
                        <div class="col-6">
                            <button type="button" onclick="closeCoverPhotoChangeDialog();"
                                class="wf-btn wf-btn-secondary">
                                {{ getJsonLocalization('home', 'Cancel') }}
                            </button>

                        </div>
                        <div class="col-6 text-end"> <button type="submit"
                                class="wf-btn wf-btn-secondary">{{ getJsonLocalization('home', 'Confirm Upload') }}</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Add CoverPhotos Picutre Modal..................................................... -->
    <!-- Previous CoverPhotos Pictures Modal............................................. -->
    <div id="previouscoverphots" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="width:40%;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{ getJsonLocalization('home', 'Previous profiles pictures') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <img src="logos//logo1.png" alt="" width="100">
                    </div>
                    <div class="text-center">
                        <?php
foreach ($oldProfilePictures as $rowInd) {
                         ?>
                        <img src="ProfileImages/Images/<?php    echo $rowInd['image_name']; ?>" alt="" width="120"
                            height="120" style="border-radius: 50%;"
                            onclick="selectOldProfileImage('<?php    echo $rowInd['image_name']; ?>');">
                        <?php
}
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Previous CoverPhotos Pictures Modal............................................. -->

    <!-- Write Your Post Modal......................................................... -->
    <div class="modal fade" id="addPostModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Create Post</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('UploadPost') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="profile-avatar-box">
                            <div class="img-box bg-light">


                                <img class="user-img" src="ProfileImages\Images\{{$userProfileData['profile_picture']}}"
                                    id="original_profile_image" alt="user image...">


                            </div>
                            <div class="user-info-box">
                                <h4 class="fw-bold mb-1" id="post">
                                    <?php  echo $userProfileData['first_name'] . ' ' . $userProfileData['second_name']; ?>
                                </h4>

                            </div>
                        </div>



                        <div class="mb-3">
                            <textarea class="form-control" id="postboxx" name="postboxx" rows="4" style="resize: none;"
                                placeholder="write your post..."></textarea>
                            <input type="hidden" class="form-control"
                                value="<?php  echo $userProfileData['email_id'];?>" name="postEmailid" id="postEmailid">
                            <input type="hidden" class="form-control"
                                value="<?php  echo $userProfileData['first_name'] . ' ' . $userProfileData['second_name']; ?>"
                                name="fullname" id="fullname">
                        </div>

                        <div id="placehere" class="bg-lightgrey p-3 rounded text-center mb-3">
                            <div id="imgUploaderView" onclick="UploadClick();">
                                <div>
                                    <img src="logos/uploadIcon.png" class="mb-2" style="opacity:.5" alt="" width="30"
                                        id="viewImgPost" />
                                </div>
                                <div>{{ getJsonLocalization('home', "Upload Photo's") }}</div>
                            </div>
                            <div class="text-start" id="subPanelHolderImg" style="display:none;">
                                <button type="button" class="btn-close mb-2" onclick="clearImages();"></button>
                                <div id="imageAppender" class="stylish-scroll stylish-scroll-thin post-image-uploader"
                                    style="max-height:208px;
                    overflow-y: auto;">
                                </div>
                            </div>
                        </div>

                        <div class="border rounded mb-3">
                            <div class="row pb-2 px-2">
                                <div class="col-6">
                                    <label style="margin-top:10px;margin-left:4px;"
                                        onclick="UploadClick();">{{ getJsonLocalization('home', 'Add to your post') }}</label>
                                </div>
                                <div class="col-6" style="text-align: right;">
                                    <input type="file" multiple style="display:none;" id="uploadImg" name="uploadImg[]"
                                        onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg1"
                                        name="uploadImg1[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg2"
                                        name="uploadImg2[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg3"
                                        name="uploadImg3[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg4"
                                        name="uploadImg4[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg5"
                                        name="uploadImg5[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg6"
                                        name="uploadImg6[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg7"
                                        name="uploadImg7[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg8"
                                        name="uploadImg8[]" onchange="PreviewImage();">
                                    <img src="logos/imgicon.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;" onclick="UploadClick();">
                                    <img src="logos/person.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;" onclick="UploadClick();">
                                    <img src="logos/smilly.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;margin-right:2px;"
                                        onclick="UploadClick();">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer border-0 p-0">
                            <button type="submit"
                                class="wf-btn wf-btn-secondary">{{ getJsonLocalization('home', 'Post') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Write Your Post Modal......................................................... -->




    <!-- callModalUserAlreadyBusy .............................................................................-->

    <div class="modal fade" id="callModalUserAlreadyBusy" tabindex="-1" role="dialog"
            aria-labelledby="callModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="callModalLabel"
                            style="font-size: 18px; font-weight: bold; letter-spacing: 1px; margin: 0; text-transform: uppercase;">
                            Call Notification</h4>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                            style="color: white; font-size: 24px; background: transparent; border: none; cursor: pointer;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                     <div class="modal-body">
                    <div style="margin-top:5px;margin-bottom:5px;background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; padding: 20px; border-radius: 8px; font-family: Arial, sans-serif; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); max-width: 400px; margin: 0 auto;">
                        <div style="font-size: 16px; font-weight: bold; text-align: center; margin-bottom: 10px;">Oops!
                        </div>
                        <p style="text-align: center; line-height: 1.6;">You cannot make a call because the user is
                            currently busy on another call. Please try again later.</p>
                    </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>


    <script>
        var isMobiles = <?php echo $isMobile;?>;


        // Adding Follows ..........................................................................
        function addFollows(personEmail) {
            var valueShow = document.getElementById('followLink' + personEmail).innerHTML;


            if (valueShow == 'Follow') {
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('addFollows.post') }}",
                    data: {
                        'email_id': personEmail
                    },
                    success: function (response) {
                        document.getElementById('followLink' + personEmail).innerHTML = 'UnFollow';
                        var countt = document.getElementById('countFollow' + personEmail).innerHTML;
                        if (countt.includes("k")) {

                        } else {
                            var d = parseInt(countt);
                            d = d + 1;
                            document.getElementById('countFollow' + personEmail).innerHTML = d + ' ';

                        }

                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            } else if (valueShow == 'UnFollow') {
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('addUnFollows.post') }}",
                    data: {
                        'email_id': personEmail
                    },
                    success: function (response) {
                        document.getElementById('followLink' + personEmail).innerHTML = 'Follow';
                        var countt = document.getElementById('countFollow' + personEmail).innerHTML;
                        if (countt.includes("k")) {

                        } else {
                            var d = parseInt(countt);
                            d = d - 1;
                            document.getElementById('countFollow' + personEmail).innerHTML = d + ' ';

                        }

                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });


            }
        }
        //..............................................................................................

        //Open Peer To Peer Video Chat Dialog Box..................................................................
        function OpenPeerToPeerVideoChatRoom(caller_name, caller_profile_pic, calling_name, calling_prfile_pic, receving_email) {

            call_type = 'Video';

            $.ajax({
                type: 'POST',
                url: "{{ route('PeerToPeerVideoCall.post')}}",
                data: {
                    'email_id_Receving': receving_email,
                    'profile_image_calling': calling_prfile_pic,
                    'caller_profile_image': caller_profile_pic,
                    'caller_name': caller_name,
                    'calling_name': calling_name,
                    'call_type': call_type
                },
                success: function (data) {
                    var obj = JSON.parse(data);
                    if (obj.hasOwnProperty('alreadyCalling')) {
                        $('#callModalUserAlreadyBusy').modal('show');
                        return;
                    }
                    if (call_type == 'Video') {

                        if (isMobiles == 1) {
                            //  window.open("{{route('videocalldashboardmobilePeerToPeer')}}", "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=400, height=1000");
                            window.open("{{route('PeerToPeerMobileVideoCallLoby')}}", "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=400, height=1000");
                        } else {
                            //#000 window.open("{{route('PeerToPeerVideoCallDesktopView')}}", "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000, height=1000");
                            var width = 1300;
                            var height = 900;
                            var screenWidth = window.innerWidth;
                            var screenHeight = window.innerHeight;
                            var left = (screenWidth - width) / 2;
                            var top = (screenHeight - height) / 2;
                            window.open("{{route('PeerToPeerVideoCallLoby')}}?channel_id="+obj.channel_id, "_blank",
                            "toolbar=yes, scrollbars=yes, resizable=yes, top=" + top + ", left=" + left + ", width=" + width + ", height=" + height);

                        }


                    }

                }, error: function (xhr, status, error) {
                    alert("Network Issue Try Again");
                }
            });
        }


        //Unfollow the user ............................................................................
        function UnaddFollows(personEmail) {


            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('addUnFollows.post') }}",
                data: {
                    'email_id': personEmail
                },
                success: function (response) {
                    //   location.reload();
                    document.getElementById("unfollowUser" + personEmail).style.display = "none";

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });



        }

        //end unfollow the user................................................................
        //Adding Comments Against Each Post.............................................................
        function addComments(postID) {

            var email_id = document.getElementById("postEmailid").value;
            var commentsTxt = document.getElementById("commentsBox" + postID).value;
            document.getElementById("commentsBox" + postID).value = '';

            var dateTimee = '<?php echo date('Y-m-d H:i:s'); ?>';

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('AddingComments.post') }}",
                data: {
                    'email_id': email_id,
                    'commentsTxt': commentsTxt,
                    'post_id': postID
                },
                success: function (data) {

                    if (data == 'done') {
                        window.location.reload();
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        }
        //..........................................................................................
        //Adding LinkeFunction Against Each Post.............................................................
        function LikeFunction(postID) {
            var email_id = document.getElementById("postEmailid").value;
            var post_liker_email_id = document.getElementById("postEmailid").value;


            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('LikePost.post') }}",

                data: {
                    'email_id': email_id,
                    'postID': postID
                },
                success: function (data) {


                    if (data == 'done') {


                        document.getElementById('likeSymble' + postID).setAttribute("class", "fa fa-thumbs-up");
                        // document.getElementById("likeButton" + postID).src =
                        //   "ProfileImages/icons/likegreen.png";

                        var countt = document.getElementById("likeCounting" + postID).textContent;
                        if (countt.length == 0) {
                            countt = "1";
                        } else {
                            var b = parseInt(countt);
                            b = b + 1;
                            countt = b + "";
                        }
                        document.getElementById("likeCounting" + postID).textContent = countt;

                    }
                    if (data == 'unlike') {

                        //   document.getElementById("likeButton" + postID).src = "ProfileImages/icons/like.png";
                        document.getElementById('likeSymble' + postID).setAttribute("class", "fa fa-thumbs-o-up");
                        var countt = document.getElementById("likeCounting" + postID).textContent;
                        if (countt.length == 0) {
                            countt = "1";
                        } else {
                            var b = parseInt(countt);
                            b = b - 1;
                            countt = b + "";
                        }
                        document.getElementById("likeCounting" + postID).textContent = countt;
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });


        }


        function closeCoverPhotoChangeDialog() {
            $('#uploadcoverphots').modal('hide');
        }

        function cancelProfilePicUpdateDialog() {
            $('#uploadiconpanel').modal('hide');
        }
    </script>

</body>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
    integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p"
    crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
    integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF"
    crossorigin="anonymous"></script>
<script type="text/javascript" src="js//url.js"></script>
@include('checkvideocallstatus')
@include('messageAjaxHomePage')

</html>