<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
</head>

<body>
    @include('header')
    <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
        <div class="container">

            <div class="form-box mx-auto" style="max-width:767px;">
                <div class="text-center mb-4">
                    <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
                </div>
                <h2>{{ getJsonLocalization('signup', 'Add Social Media Links') }}</h2>
                <form method="POST" action="{{ route('actionSocialLinks') }}">
                    @csrf
                    <div class="row mb-3 gy-2">
                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-facebook" style="color:#126681"></i> <label class="text-mini">{{ getJsonLocalization('signup', 'Facebook') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="facebook" id="facebook" value="" >
                        </div>

                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-twitter" style="color:#126681"> </i> <label class="text-mini">{{ getJsonLocalization('signup', 'Twiter') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="twiter" id="twiter" value="" >
                        </div>


                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-linkedin" style="color:#126681"> </i> <label class="text-mini">{{ getJsonLocalization('signup', 'linkedin') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="linkedin" id="linkedin" value="" >
                        </div>

                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-instagram" style="color:red"> </i> <label class="text-mini">{{ getJsonLocalization('signup', 'Instagram') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="Instagram" id="Instagram" value="" >
                        </div>
                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-youtube" style="color:red"> </i> <label class="text-mini">{{ getJsonLocalization('signup', 'Youtube') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="youtube" id="youtube" value="" >
                        </div>
                        <div class="col-sm-12">
                        <i class="footer-social-icon fa fa-github" style="color:#126681"> </i> <label class="text-mini">{{ getJsonLocalization('signup', 'github') }}:</label>
                            <input type="text" autocomplete="off" class="form-control" name="github" id="github" value="" >
                       <br>
                        </div>



                    <div class="row">

                        <div class="col-6">
                            <a href="{{ route('signup') }}" type="button" class="wf-btn wf-btn-secondary">
                                {{ getJsonLocalization('signup', 'Go Back') }}
                            </a>
                        </div>
                        <div class="col-6 text-end">
                            <button type="submit" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Next') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
</body>

</html>