<?php
session_start();

use Illuminate\Support\Facades\Session;
$userInfo = Session::get('userInfo');

if ($userInfo && $userInfo['acountType'] !== 'org') {
    return redirect('404');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <style>
        .fixed-left-sidebar {
            position: sticky;
            top: 0;
            height: 100vh;
            overflow: auto;
        }
    </style>
</head>

<body>
    @include('header')
    <div class="container-fluid app-wrapper-container">
        <div class="row min-vh-100">
            <div class="col-md-4 col-12 p-5 text-center" style="border-right: 2px solid #ccc;">
                <div class="my-5">
                    <img src="{{ URL::to('/') }}/logos//logo1.png" alt="" width="250">
                </div>
                <div>
                    <div class="h4 mb-4">{{ getJsonLocalization('interview', 'Search a job interview') }}</div>
                    <form action="#">
                        <input type="text" class="form-control mb-3" placeholder="Name" required>
                        <input type="text" class="form-control mb-3" placeholder="Upload Date" required>
                        <input type="text" class="form-control mb-3" placeholder="Field" required>
                        <input type="text" class="form-control mb-4" placeholder="Ethnicity" required>
                        <button type="submit"
                            class="wf-btn wf-btn-primary w-100">{{ getJsonLocalization('interview', 'Search') }}</button>
                    </form>
                </div>
            </div>
            <div class="col-xl-8 col-12 p-5 overflow-auto">
                <div class="row">
                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-sm-6 col-md-6 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="position-relative">
                                <video width="100%"
                                    style="border-top-left-radius: 30px; border-top-right-radius: 30px;">
                                    <source
                                        src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                                        type="video/mp4">
                                </video>
                                <span class="position-absolute text-white mb-3 me-3 bottom-0 end-0">25:12</span>
                            </div>
                            <div class="card-body p-4">
                                <p class="card-text fs-5">
                                    <span>John_Levis_02/05/2023</span> <br>
                                    <span class="text-success">1.7k
                                    </span>{{ getJsonLocalization('interview', 'views') }} <br>
                                    <span class="text-success">58k
                                    </span>{{ getJsonLocalization('interview', 'likes') }}
                                    <br>
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</body>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"></script>

</html>
