<?php
session_start();

use App\Models\Education;
use App\Models\FollowerCount;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\PostData;
use App\Models\PostLike;
use App\Models\Follower;
use App\Models\ExamList;
use App\Models\comments_adds;
use App\Models\social_media_link;
use App\Models\profile_images;
use App\Models\diploma_education;
use App\Models\WorkingExperience;
use App\Models\profile_image_change_record;

$collapserCounter = 0;
$jobpost = "";

// Remove Query here and paste it on home controller

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>


    <script type="text/javascript" src="js//url.js"></script>

    <script src="js//top_user_search.js" data-search-url="{{ route('searchResult.get') }}"></script>
</head>

<body onload="showDialog()">
    @include('homedesktopheader')

    <section class="section-padding">
        <div class="container">
            <input type="button" id="showReturn" data-bs-toggle="modal" data-bs-target="#jobsubmissionMessage"
                style="display:none;">
        </div>
        <form method="POST" action="submitJobInfo" enctype="multipart/form-data">
            @csrf
            <div class="container-medium">
                <div class="py-4 px-3 p-sm-4 border rounded-lg bg-white">
                    <div class="border-bottom pb-4 text-center">
                        <img src="logos//logo1.png" alt="" width="130">
                    </div>
                    <div class="pt-4">
                        <div id="tab1">
                            <h3 class="mb-5 text-primary text-center">
                                {{ getJsonLocalization('postjob', 'Create a Job') }}
                            </h3>
                            <div class="row gy-4">
                                <div class="col-12">
                                    <img src="logos//img.png" alt="Girl in a jacket" width="80" height="80"
                                        name="profile_img1" id="profile_img1" style="border-radius: 50%;">
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'Title of the jobs') }}</label>
                                        <input type="text" autocomplete="off" class="form-control" id="job_title" name="job_title"
                                            aria-describedby="emailHelp" required
                                            placeholder="{{ getJsonLocalization('postjob', 'Title of the jobs') }}">
                                    </div>
                                </div>
                                <!-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label
                                            for="exampleFormControlSelect1">{{ getJsonLocalization('postjob', 'Field') }}</label>
                                        <select class="form-select" id="field" name="field" required>
                                            <option value="">{{ getJsonLocalization('index', 'Select') }}</option>

                                            <option value="Health">
                                                {{ getJsonLocalization('index', 'Health') }}
                                            </option>
                                            <option value="Finance">
                                                {{ getJsonLocalization('index', 'Finance') }}
                                            </option>
                                            <option value="T.I Programming">
                                                {{ getJsonLocalization('index', 'TIProgramming') }}
                                            </option>
                                            <option value="T.I Tech Support">
                                                {{ getJsonLocalization('index', 'TITechSupport') }}
                                            </option>
                                            <option value="T.I Tech Data">
                                                {{ getJsonLocalization('index', 'TITechData') }}
                                            </option>
                                            <option value="Video Games and 3D">
                                                {{ getJsonLocalization('index', 'Video Games and 3D') }}
                                            </option>
                                            <option value="Engineering">
                                                {{ getJsonLocalization('index', 'Engineering') }}
                                            </option>
                                            <option value="Calling Center">
                                                {{ getJsonLocalization('index', 'Calling Center') }}
                                            </option>
                                            <option value="Office">
                                                {{ getJsonLocalization('index', 'Office') }}
                                            </option>
                                            <option value="Inforgraphy and Design">
                                                {{ getJsonLocalization('index', 'Inforgraphy and Design') }}
                                            </option>
                                            <option value="Cleaning">
                                                {{ getJsonLocalization('index', 'Cleaning') }}
                                            </option>
                                            <option value="Marketing and Sales">
                                                {{ getJsonLocalization('index', 'Marketing and Sales') }}
                                            </option>
                                            <option value="Warehouse">
                                                {{ getJsonLocalization('index', 'Warehouse') }}
                                            </option>
                                            <option value="Factory">
                                                {{ getJsonLocalization('index', 'Factory') }}
                                            </option>
                                            <option value="Security Guard">
                                                {{ getJsonLocalization('index', 'Security Guard') }}
                                            </option>
                                            <option value="Human Resources">
                                                {{ getJsonLocalization('index', 'Human Resources') }}
                                            </option>
                                            <option value="Management">
                                                {{getJsonLocalization('index', 'Management') }}
                                            </option>
                                            <option value="Science">
                                                {{ getJsonLocalization('index', 'Science') }}
                                            </option>
                                            <option value="Teacher">
                                                {{ getJsonLocalization('index', 'Teacher') }}
                                            </option>
                                            <option value="Other">
                                                {{ getJsonLocalization('index', 'Other') }}
                                            </option>

                                        </select>
                                    </div>
                                </div> -->
                                <div class="col-md-6">
                                    <label>{{ getJsonLocalization('postjob', 'Category') }}:</label><br>
                                    <select class="form-select" id="categoryList" name="categoryList" required>

                                    <option value="0" >
                                       Select Category
                                        </option>
                                    @foreach($Category_Result as $category)
                                        <option value="{{ $category->id }}" >

                                        {{ getJsonLocalization('index',  $category->category ) }}
                                        </option>
                                            <!-- Change 'name' to the actual column you want to display -->
                                        @endforeach

                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>{{ getJsonLocalization('postjob', 'job offer picture') }}:</label><br>
                                    <input type="file" class="form-control" id="customFile" name="customFile"
                                        accept=".png,.jpg,.jpeg" onchange="PreviewImage();" />
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label
                                            for="exampleInputEmail1">{{ getJsonLocalization('postjob', 'Country') }}:</label>
                                        <select class="form-select" required id="country_name" name="country_name">
                                            <option value="">{{ getJsonLocalization('postjob', 'Country') }}
                                            </option>
                                            <option value="Health">{{ getJsonLocalization('postjob', 'USA') }}
                                            </option>
                                            <option value="Finances">{{ getJsonLocalization('postjob', 'Canada') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label
                                            for="exampleInputEmail1">{{ getJsonLocalization('postjob', 'City Name') }}:</label>
                                        <input type="text" autocomplete="off" required class="form-control" id="city_name" name="city_name"
                                            aria-describedby="emailHelp"
                                            placeholder="{{ getJsonLocalization('postjob', 'City Name') }}" value="">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" class="mb-2">
                                        <label
                                            for="exampleInputEmail1">{{ getJsonLocalization('postjob', 'Address') }}</label>
                                        <input type="text" autocomplete="off" required class="form-control" id="address" name="address"
                                            aria-describedby="emailHelp"
                                            placeholder="{{ getJsonLocalization('postjob', 'Address') }}"
                                            autcomplete="off">
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div style="display:none;" id="tab2">
                            <h3 class="mb-5 text-primary text-center">
                                {{ getJsonLocalization('postjob', 'Job Details') }}
                            </h3>
                            <div class="mb-4">
                                <div class="mb-3 purple-border">
                                    <label class="mb-2"
                                        for="exampleFormControlTextarea4">{{ getJsonLocalization('postjob', 'Description') }}</label>
                                    <textarea class="form-control"
                                        style="resize: none;font-size: 14px;white-space: pre-wrap; text-indent: 0px;"
                                        id="description" name="description" rows="5"></textarea>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" onclick="addDotDes();" type="radio"
                                        name="desCheckbox" id="desCheckbox">
                                    <script>
                                        var des = false;

                                        function addDotDes() {

                                            let text = "⦿";

                                            var b = '⦿';
                                            if (des == false) {
                                                document.getElementById("description").value = b;
                                                document.getElementById("description").style.fontSize = "20px";
                                                des = true;
                                            } else {
                                                document.getElementById("description").value = document.getElementById("description").value + '\n' + b;
                                            }

                                            document.getElementById("desCheckbox").checked = false;;

                                        }
                                    </script>
                                </div>
                            </div>
                            <div class="mb-4">
                                <div class="mb-3 purple-border">
                                    <label class="mb-2"
                                        for="exampleFormControlTextarea4">{{ getJsonLocalization('postjob', 'Requirement') }}</label>
                                    <textarea class="form-control"
                                        style="resize: none;font-size: 14px;white-space: pre-wrap; text-indent: 0px;"
                                        id="requirement" name="requirement" rows="5"></textarea>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" onclick="addDot();" type="radio" name="reqCheckbox"
                                        id="reqCheckbox">
                                    <script>
                                        var req = false;

                                        function addDot() {

                                            let text = "⦿";

                                            var b = '⦿';
                                            if (req == false) {
                                                document.getElementById("requirement").value = b;
                                                document.getElementById("requirement").style.fontSize = "20px";
                                                req = true;
                                            } else {
                                                document.getElementById("requirement").value = document.getElementById("requirement").value + '\n' + b;
                                            }

                                            document.getElementById("reqCheckbox").checked = false;;

                                        }
                                    </script>
                                </div>
                            </div>
                            <div class="mb-4">
                                <div class="mb-3 purple-border">
                                    <label class="mb-2"
                                        for="exampleFormControlTextarea4">{{ getJsonLocalization('postjob', 'Task') }}</label>
                                    <textarea class="form-control"
                                        style="resize: none;font-size: 14px;white-space: pre-wrap; text-indent: 0px;"
                                        id="Task" name="Task" rows="5"></textarea>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" onclick="addDotTask();"
                                        name="taskCheckBox" id="taskCheckBox">
                                </div>
                                <script>
                                    var firstTask = false;

                                    function addDotTask() {
                                        let text = "⦿";

                                        var b = '⦿';
                                        if (firstTask == false) {
                                            document.getElementById("Task").value = b;
                                            document.getElementById("Task").style.fontSize = "20px";
                                            firstTask = true;
                                        } else {
                                            document.getElementById("Task").value = document.getElementById("Task").value + '\n' + b;

                                        }

                                        document.getElementById("taskCheckBox").checked = false;;

                                    }
                                </script>
                            </div>
                        </div>
                        <div style="display:none;" id="tab3">
                            <h3 class="text-primary mb-5 text-center">
                                {{ getJsonLocalization('postjob', 'Schedules and additional information') }}
                            </h3>
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'schedule') }}:</label>
                                        <select class="form-select" id="schedule" name="schedule">
                                            <option value="">
                                                {{ getJsonLocalization('postjob', 'Select Schedule') }}
                                            </option>
                                            <option value="Full-time">{{ getJsonLocalization('postjob', 'FullTime') }}
                                            </option>
                                            <option value="Part-time">{{ getJsonLocalization('postjob', 'PartTime') }}
                                            </option>
                                            <option value="On-call">{{ getJsonLocalization('postjob', 'OnCall') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'salary') }}:</label>
                                        <input type="number" class="form-control" id="salary" name="salary"
                                            aria-describedby="emailHelp"
                                            placeholder="{{ getJsonLocalization('postjob', 'Enter Salary') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'mode') }}:</label>
                                        <select class="form-select" id="mode" name="mode">
                                            <option value="">{{ getJsonLocalization('postjob', 'Select Mode') }}
                                            </option>
                                            <option value="On-site">{{ getJsonLocalization('postjob', 'Onsite') }}
                                            </option>
                                            <option value="Hybrid">{{ getJsonLocalization('postjob', 'Hybrid') }}
                                            </option>
                                            <option value="Home">{{ getJsonLocalization('postjob', 'Home') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'duration') }}:</label>
                                        <select class="form-select" id="duration" name="duration">
                                            <option value="">
                                                {{ getJsonLocalization('postjob', 'Select Duration') }}
                                            </option>
                                            <option value="Permanent">
                                                {{ getJsonLocalization('postjob', 'Permanent') }}
                                            </option>
                                            <option value="temporary">
                                                {{ getJsonLocalization('postjob', 'temporary') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'Driver license') }}:</label>
                                        <select class="form-select" id="driver_license" name="driver_license">
                                            <option value="">
                                                {{ getJsonLocalization('postjob', 'Select License') }}
                                            </option>
                                            <option value="Required">{{ getJsonLocalization('postjob', 'Required') }}
                                            </option>
                                            <option value="Not required">
                                                {{ getJsonLocalization('postjob', 'Not required') }}
                                            </option>
                                            <option value="Recommended">
                                                {{ getJsonLocalization('postjob', 'Recommended') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'car') }}:</label>
                                        <select class="form-select" id="car" name="car">
                                            <option value="">
                                                {{ getJsonLocalization('postjob', 'Select Car Status') }}
                                            </option>
                                            <option value="Required">{{ getJsonLocalization('postjob', 'Required') }}
                                            </option>
                                            <option value="Not required">
                                                {{ getJsonLocalization('postjob', 'Not required') }}
                                            </option>
                                            <option value="Recommended">
                                                {{ getJsonLocalization('postjob', 'Recommended') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"
                                            class="mb-2">{{ getJsonLocalization('postjob', 'Workfrater exam') }}:</label><br>
                                        <button type="button" class="wf-btn wf-btn-primary w-100" data-bs-toggle="modal"
                                            data-bs-target="#selectExamModel">{{ getJsonLocalization('postjob', 'Add An Exam') }}</button>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div id="myDIV"></div>
                                    <input type="hidden" name="examDetail" id="examDetail">
                                </div>
                            </div>
                        </div>
                        <div style="display:none;" id="tab4">
                            <h3 class="mb-5 text-primary">
                                {{ getJsonLocalization('postjob', 'Candidate Requirements') }}
                            </h3>
                            <div class="row gy-3 mb-5">
                                <div class="col-12 col-sm-3">
                                    <h6>{{ getJsonLocalization('postjob', 'Age Between') }}</h6>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <select style="width:50px;" class="form-control" id="candiateAgeStart"
                                        name="candiateAgeStart">
                                        <?php
for ($v = 18; $v < 100; $v++) {
                                        ?>
                                        <option value="<?php    echo $v; ?>"><?php    echo $v; ?></option>
                                        <?php
}

                                        ?>
                                    </select>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <h6>{{ getJsonLocalization('postjob', 'And') }}</h6>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <select style="width:50px;" class="form-control" id="candiateAgeEnd"
                                        name="candiateAgeEnd">
                                        <?php
for ($v = 19; $v < 100; $v++) {
                                        ?>
                                        <option value="<?php    echo $v; ?>"><?php    echo $v; ?></option>
                                        <?php
}

                                        ?>
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-5 gy-3">
                                <div class="col-12">
                                    <h6 class="mb-0">{{ getJsonLocalization('postjob', 'Sex') }}</h6>
                                </div>
                                <div class="col-6 col-md-3">
                                    <input class="form-check-input" type="radio" name="genders" id="male" value="male">
                                    <label for="male"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'Male') }}</label>
                                </div>
                                <div class="col-6 col-md-3">
                                    <input class="form-check-input" type="radio" name="genders" id="female"
                                        value="female"> <label for="female"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'Female') }}</label>
                                </div>
                                <div class="col-6 col-md-3">
                                    <input class="form-check-input" type="radio" name="genders" id="other"
                                        value="other"><label for="other"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'Other') }}</label>
                                </div>
                                <div class="col-6 col-md-3">
                                    <input class="form-check-input" type="radio" name="genders" id="all"
                                        value="all"><label for="all"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'All') }}</label>
                                </div>
                            </div>

                            <!-- <div id="ethnicity" class="mt-4" style="display:none;">
                                <h5>{{ getJsonLocalization('postjob', 'Ethnicity') }}</h5>
                                <div class="row gy-3">
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="Caucasian1" id="Caucasian1"> <label for="male">{{ getJsonLocalization('postjob', 'Caucasian') }}</label>
                                    </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="south-asian1" id="south-asian1"><label for="male">{{ getJsonLocalization('postjob', 'south-asian') }}</label>
                                    </div>
                                    <div class="col-md-4"><input class="form-check-input" type="checkbox" name="Hispanic1" id="Hispanic1"><label for="male">{{ getJsonLocalization('postjob', 'Hispanic') }}</label>
                                    </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="mixed1" id="mixed1"> <label for="male">{{ getJsonLocalization('postjob', 'mixed') }}</label>
                                    </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="African1" id="African1"> <label for="male">{{ getJsonLocalization('postjob', 'African') }}</label>
                                    </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="middle-eastern1" id="middle-eastern1"> <label for="male">{{ getJsonLocalization('postjob', 'middle-eastern') }}</label>
                                    </div>
                                    <div class="col-md-4"><input class="form-check-input" type="checkbox" name="Afro-latin1" id="Afro-latin1"> <label for="male">{{ getJsonLocalization('postjob', 'Afro-latin') }}
                                        </label> </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="other1" id="other1"> <label for="male">{{ getJsonLocalization('postjob', 'Other') }} </label>
                                    </div>
                                    <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="Asian1" id="Asian1"><label for="male">{{ getJsonLocalization('postjob', 'Asian') }} </label>
                                    </div>
                                    <div class="col-md-4"><input class="form-check-input" type="checkbox" name="North-african1" id="North-african1"><label for="male">{{ getJsonLocalization('postjob', 'North-african') }}
                                        </label> </div>
                                    <div class="col-md-4"><input class="form-check-input" type="checkbox" name="Native_american1" id="Native_american1"> <label for="male">{{ getJsonLocalization('postjob', 'Native american') }}
                                        </label> </div>
                                </div>
                            </div> -->

                        </div>
                        <div style="display:none;" id="tab5">
                            <h3 class="mb-4 text-center text-primary">
                                {{ getJsonLocalization('postjob', 'Who can see this job offer') }}
                            </h3>
                            <div class="text-center">
                                <button type="button" class="wf-btn wf-btn-primary" data-bs-toggle="modal"
                                    data-bs-target="#addFilderModel">{{ getJsonLocalization('postjob', 'Add a filter') }}</button>
                            </div>
                            <div class="row mt-4">
                                <div class="col-md-12" style="text-align: left;font-size:18px;font-weight: bold;"
                                    id="myDIVFilter"></div>
                                <input type="hidden" name="filterList" id="filterList">
                            </div>
                        </div>

                        <div style="display:none;" id="tab6">
                            <h3 class="mb-4 text-center text-primary">
                                {{ getJsonLocalization('postjob', 'Do you want to add questions to your job offer?') }}
                            </h3>
                            <br>

                            <!--  Submiting Question data here as an object  -->
                            <div id="object-container" style="width:100%;">

                            </div>
                            <!--................................................. -->
                            <br> <br>
                            <div class="text-center"><button type="button" class="wf-btn wf-btn-secondary"
                                    data-bs-toggle="modal"
                                    data-bs-target="#addQuestionManual">{{ getJsonLocalization('postjob', 'Add a question') }}</button>
                            </div>




                        </div>
                        <div style="display:none;" id="tab7">
                            <h2 class="text-primary mb-5">{{ getJsonLocalization('postjob', 'Job Detail') }}</h2>
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="row gy-4">
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'job title') }}:</b></div>
                                            <p id="job_titless"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'field') }}:</b></div>
                                            <p id="field_show"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{getJsonLocalization("postjob", "Address")}}:</b></div>
                                            <p id="address_show"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Job Description') }} :</b></div>
                                            <p id="job_des"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Requirement') }} :</b></div>
                                            <p id="job_Req"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Task') }} :</b></div>
                                            <p id="job_Task"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Schedule') }} :</b></div>
                                            <p id="job_Schedule"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'mode') }} :</b></div>
                                            <p id="job_mode"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', "Driver's license") }} :</b>
                                            </div>
                                            <p id="job_driver_license"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Car') }} :</b></div>
                                            <p id="job_car"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Workfrater exam') }} :</b></div>
                                            <p id="workfrater_exam"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Age') }} :</b></div>
                                            <p id="job_age"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Sex') }} :</b></div>
                                            <p id="job_sex"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Ethnicity') }} :</b></div>
                                            <p id="job_Ethnicity"></p>
                                        </div>
                                        <div class="col-md-6">
                                            <div><b>{{ getJsonLocalization('postjob', 'Picture') }} :</b></div>
                                            <img src="logos//img.png" alt="Girl in a jacket" width="80" height="80"
                                                name="profile_img2" id="profile_img2" style="border-radius: 50%">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>





                        <div class="mt-4 border-top pt-4">
                            <div class="d-flex justify-content-between gap-3 w-100">
                                <div>
                                    <button type="button" id="PrevousButtons" class="wf-btn wf-btn-secondary"
                                        style="display:none;"
                                        onclick="previousTab();">{{ getJsonLocalization('postjob', 'Previous') }}</button>
                                </div>
                                <div id="nextButtonDiv">
                                    <button type="button" class="wf-btn wf-btn-secondary" id="nextButtonOption"
                                        onclick="nextTab();">{{ getJsonLocalization('postjob', 'Next') }}</button>

                                </div>
                                <div id="submitForm" style="display: none; !important;">

                                    <button type="submit" class="wf-btn wf-btn-primary ms-3"
                                        style="display: none;">{{ getJsonLocalization('postjob', 'Submit') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="startAge" id="startAge">
            <input type="hidden" name="endAge" id="endAge" >
            <input type="hidden" name="genderSelected" id="genderSelected" >
            <input type="hidden" name="status" id="status">
            <input type="hidden" name="carvslicenance" id="carvslicenance"  >

            <input type="hidden" name="entList" id="entList" >
        </form>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
            integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
            </script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
            integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
            </script>
        <script type="text/javascript" src="js//url.js"></script>

        <div class="modal fade" id="addQuestionManual" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>{{ getJsonLocalization('postjob', 'Add a question') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <img src="logos//logo1.png" alt="" width="100">
                        </div>
                        <div class="form-group mb-4">
                            <label
                                for="exampleFormControlTextarea1">{{ getJsonLocalization('postjob', 'Question') }}:</label>
                            <textarea class="form-control" id="questionText" name="questionText" rows="3" style="resize: none;"></textarea>
                        </div>

                        <div class="row gy-3 mb-4">
                            <div class="col-4 text-center">
                                <button type="button" class="wf-btn wf-btn-primary"
                                    onclick="showYesNo();">{{ getJsonLocalization('postjob', 'YES/NO') }}</button>
                            </div>
                            <div class="col-4 text-center">
                                <button type="button" class="wf-btn wf-btn-primary"
                                    onclick="showChoices();">{{ getJsonLocalization('postjob', 'choices') }}</button>
                            </div>
                            <div class="col-4 text-center">
                                <button type="button" class="wf-btn wf-btn-primary"
                                    onclick="showTextBox();">{{ getJsonLocalization('postjob', 'text') }}</button>
                            </div>
                        </div>

                        <div style="display:none;" id="yesnoOption">
                            <div class="row gy-3">
                                <div class="col-sm-2"><input class="form-check-input" type="radio"><label for="male"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'Yes') }}</label>
                                </div>
                                <div class="col-sm-3"><input class="form-check-input" type="radio"><label for="male"
                                        style="margin-left:2px;">{{ getJsonLocalization('postjob', 'No') }}</label>
                                </div>
                            </div>
                        </div>
                        <div style="display:none;" id="choices">
                            <div class="form-group mb-3">
                                <label
                                    for="exampleInputEmail1">{{ getJsonLocalization('postjob', 'Add option') }}</label>
                                <input type="text" autocomplete="off" class="form-control" id="questionOptionTextBox"
                                    aria-describedby="emailHelp" placeholder="option">
                            </div>
                            <button type="button" class="wf-btn wf-btn-secondary"
                                onclick="addOptions();">{{ getJsonLocalization('postjob', 'Add') }}</button>

                            <div class="row" style="margin-top:10px;">
                                <div class="col-md-6" style="text-align: left;font-size:18px;font-weight: bold;"
                                    id="questionOpt"></div>
                            </div>
                        </div>
                        <div style="display:none;" id="showTextBox">
                            <textarea class="form-control" rows="3" disabled style="resize: none;"></textarea>
                        </div>

                    </div>
                    <script>
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        var questionOpt = "";

                        function showYesNo() {
                            questionOpt = "yesno";
                            document.getElementById("yesnoOption").style.display = 'block';
                            document.getElementById("choices").style.display = 'none';
                            document.getElementById("showTextBox").style.display = 'none';
                        }

                        function showTextBox() {
                            questionOpt = "TextBox";
                            document.getElementById("showTextBox").style.display = 'block';
                            document.getElementById("yesnoOption").style.display = 'none';
                            document.getElementById("choices").style.display = 'none';
                        }

                        function showChoices() {
                            questionOpt = "showChoices";
                            document.getElementById("yesnoOption").style.display = 'none';
                            document.getElementById("choices").style.display = 'block';
                            document.getElementById("showTextBox").style.display = 'none';
                        }
                        var qCounter = 0;
                        var optionArray = [];

                        function addOptions() {
                            if (qCounter == 4) {
                                alert("Only 4 Option can be added");
                                return;
                            }
                            optionArray[qCounter] = document.getElementById("questionOptionTextBox").value;
                            qCounter = qCounter + 1;
                            let newbtn = document.createElement("appendText");
                            var elem2 = document.createElement('label');
                            elem2.innerHTML = "Opt: " + document.getElementById("questionOptionTextBox").value;
                            document.getElementById("questionOptionTextBox").value = "";

                            newbtn.appendChild(elem2);

                            let xspan = document.createElement('span');

                            xspan.innerHTML = '<sup style="margin-left:8px;"><a href="javascript:FunctionCall();">X</a></sup>'; //this gives it superscript text
                            xspan.id = 'close'; //this was not necessary but it is nice to have
                            xspan.onclick = function () {
                                qCounter = qCounter - 1;

                                for (var i = 0; i < optionArray.length; i++) {
                                    var value = optionArray[i];
                                    if (newbtn.innerHTML.includes("Opt: " + value)) {
                                        optionArray = optionArray.filter(item => item !== value)
                                    }

                                }

                                newbtn.remove();
                                br.remove();




                            };
                            newbtn.appendChild(xspan);
                            document.getElementById("questionOpt").appendChild(newbtn);
                            var br = document.createElement("br");
                            document.getElementById("questionOpt").appendChild(br);
                            document.getElementById("questionOpt").appendChild(br);
                            var qText = document.getElementById("questionText").value;
                            var job_detail = document.getElementById("job_title").value;
                            var optionText = document.getElementById("questionOptionTextBox").value;




                        }
                    </script>
                    <div class="modal-footer">

                        <button type="button" class="wf-btn wf-btn-secondary"
                            onclick="addQuestion();">{{ getJsonLocalization('postjob', 'Add') }}</button>

                        <script>
                            function closeAddQuestion() {
                                document.getElementById("closeQuestionWindow").click();
                            }
                            var objectIndex = 1;
                            function addQuestion() {

                                if (questionOpt == "yesno") {
                                    const container = document.getElementById('object-container');
                                    const newObject = document.createElement('div');

                                    newObject.className = 'object-group';
                                    newObject.style.width = "100%";
                                    const nameInput = document.createElement('input');
                                    nameInput.style = "border: none;display:none;"


                                    nameInput.setAttribute('name', `YesNo[${objectIndex}][name]`);
                                    nameInput.setAttribute('id', `name${objectIndex}`);
                                    nameInput.setAttribute('value', document.getElementById("questionText").value);

                                    const qutNumber = document.createElement('label');
                                    qutNumber.innerHTML = "<b>Q:<b>";

                                    const labelQText = document.createElement('label');
                                    labelQText.innerHTML = document.getElementById("questionText").value;
                                    labelQText.style.marginLeft = "10px";


                                    const labelObj = document.createElement('label');
                                    labelObj.innerHTML = "<b>Yes</b>";
                                    labelObj.style.marginLeft = "10px";
                                    const labelObj2 = document.createElement('label');
                                    labelObj2.style.marginLeft = "10px";
                                    labelObj2.innerHTML = "<b>No</b>";

                                    let xspan = document.createElement('span');
                                    xspan.innerHTML =
                                        '<a href="javascript:FunctionCall();" style="margin-left:5px;">Delete</a>'; //this gives it superscript text
                                    xspan.id = 'close'; //this was not necessary but it is nice to have
                                    xspan.onclick = function () {
                                        objectIndex = objectIndex - 1;
                                        newObject.remove();
                                        br.remove();
                                    };
                                    newObject.appendChild(qutNumber);
                                    newObject.appendChild(labelQText);
                                    newObject.appendChild(labelObj);
                                    newObject.appendChild(labelObj2);
                                    newObject.appendChild(nameInput);
                                    newObject.appendChild(xspan);
                                    container.appendChild(newObject);

                                    objectIndex++;
                                }

                                if (questionOpt == 'showChoices') {


                                    const container = document.getElementById('object-container');
                                    const newObject = document.createElement('div');

                                    newObject.className = 'object-group';
                                    newObject.style.width = "100%";

                                    const nameInput = document.createElement('input');
                                    nameInput.style = "border: none;display:none;"
                                    nameInput.setAttribute('name', `OptQuestion[${objectIndex}][name]`);
                                    nameInput.setAttribute('id', `name${objectIndex}`);


                                    const qutNumber = document.createElement('label');
                                    qutNumber.innerHTML = "<b>Q:<b>";

                                    const labelQText = document.createElement('label');
                                    labelQText.innerHTML = document.getElementById("questionText").value;
                                    labelQText.style.marginLeft = "10px";
                                    newObject.appendChild(qutNumber);
                                    newObject.appendChild(labelQText);

                                    var optionList = "";
                                    for (var k = 0; k < optionArray.length; k++) {

                                        var rowNum = k + 1;
                                        const labelObj = document.createElement('label');
                                        labelObj.innerHTML = "<b>" + rowNum + ": </b>" + optionArray[k];
                                        labelObj.style.marginLeft = "10px";
                                        newObject.appendChild(labelObj);
                                        optionList = optionList + "|" + optionArray[k];

                                    }
                                    optionArray = [];

                                    var choicesQuestion = document.getElementById("questionText").value + optionList;
                                    nameInput.setAttribute('value', choicesQuestion);
                                    newObject.appendChild(nameInput);
                                    let xspan = document.createElement('span');
                                    xspan.innerHTML =
                                        '<a href="javascript:FunctionCall();" style="margin-left:5px;">Delete</a>'; //this gives it superscript text
                                    xspan.id = 'close'; //this was not necessary but it is nice to have
                                    xspan.onclick = function () {
                                        objectIndex = objectIndex - 1;
                                        newObject.remove();
                                        br.remove();
                                    };



                                    newObject.appendChild(xspan);
                                    container.appendChild(newObject);

                                    objectIndex++;

                                }




                                if (questionOpt == 'TextBox') {

                                    const container = document.getElementById('object-container');
                                    const newObject = document.createElement('div');

                                    newObject.className = 'object-group';
                                    newObject.style.width = "100%";

                                    const nameInput = document.createElement('input');
                                    nameInput.style = "border: none;display:none;"
                                    nameInput.setAttribute('name', `TextBased[${objectIndex}][name]`);
                                    nameInput.setAttribute('id', `name${objectIndex}`);


                                    const qutNumber = document.createElement('label');
                                    qutNumber.innerHTML = "<b>Q:<b>";

                                    const labelQText = document.createElement('label');
                                    labelQText.innerHTML = document.getElementById("questionText").value;
                                    labelQText.style.marginLeft = "10px";
                                    newObject.appendChild(qutNumber);
                                    newObject.appendChild(labelQText);

                                    let xspan = document.createElement('span');
                                    xspan.innerHTML =
                                        '<a href="javascript:FunctionCall();" style="margin-left:5px;">Delete</a>'; //this gives it superscript text
                                    xspan.id = 'close'; //this was not necessary but it is nice to have
                                    xspan.onclick = function () {
                                        objectIndex = objectIndex - 1;
                                        newObject.remove();
                                        br.remove();
                                    };



                                    newObject.appendChild(xspan);
                                    container.appendChild(newObject);

                                    objectIndex++;
                                }









                                //    document.getElementById("closeQuestionWindow").click();
                                let newbtn = document.createElement("appendText");
                                var elem2 = document.createElement('label');
                                elem2.innerHTML = document.getElementById("questionText").value;

                                newbtn.appendChild(elem2);

                                let xspan = document.createElement('span');
                                xspan.innerHTML =
                                    '<sup style="margin-left:0px;"><a href="javascript:FunctionCall();">X</a></sup>'; //this gives it superscript text
                                xspan.id = 'close'; //this was not necessary but it is nice to have
                                xspan.onclick = function () {
                                    // oldExamValue="";
                                    //       var appendTxx=newbtn.innerHTML;
                                    //          for (var s=0;s<examListName.length;s++) {
                                    //              if(appendTxx.indexOf(examListName[s]) === -1){
                                    //             oldExamValue=oldExamValue+","+examListName[s];
                                    //          }
                                    //          }

                                    // document.getElementById("examDetail").value=oldExamValue;
                                    newbtn.remove();
                                    br.remove();
                                };
                                newbtn.appendChild(xspan);




                                var qText = document.getElementById("questionText").value;
                                var job_detail = document.getElementById("job_title").value;
                                // if (questionOpt == 'yesno') {
                                //     $.ajax({
                                //         type: 'POST',
                                //         url: "{{ route('addQuestion.post') }}",
                                //         data: {
                                //             'questionType': 'yesno',
                                //             'questionText': qText,
                                //             'jobDetail': job_detail
                                //         },
                                //         success: function(data) {


                                //         },
                                //         error: function(xhr, status, error) {
                                //             alert(xhr.responseText);
                                //         }
                                //     });
                                // }

                                // if (questionOpt == 'TextBox') {
                                //     $.ajax({
                                //         type: 'POST',
                                //         url: "{{ route('addQuestion.post') }}",
                                //         data: {
                                //             'questionType': 'textbox',
                                //             'questionText': qText,
                                //             'jobDetail': job_detail
                                //         },
                                //         success: function(data) {


                                //         },
                                //         error: function(xhr, status, error) {
                                //             alert(xhr.responseText);
                                //         }
                                //     });
                                // }

                                // if (questionOpt == 'showChoices') {
                                //     $.ajax({
                                //         type: 'POST',
                                //         url: "{{ route('addQuestion.post') }}",
                                //         data: {
                                //             'questionType': 'choices',
                                //             'questionText': qText,
                                //             'jobDetail': job_detail
                                //         },
                                //         success: function(data) {


                                //         },
                                //         error: function(xhr, status, error) {
                                //             alert(xhr.responseText);
                                //         }
                                //     });
                                // }


                                document.getElementById("questionText").value = "";
                                document.getElementById("yesnoOption").style.display = 'none';
                                document.getElementById("choices").style.display = 'none';
                                document.getElementById("showTextBox").style.display = 'none';
                            }
                        </script>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="addFilderModel" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ getJsonLocalization('postjob', 'Filter') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <img src="logos//logo1.png" alt="" width="100">
                        </div>
                        <div class="row gy-2 my-4">
                            <ul class="nav nav-tabs">
                                <li class="nav-item">
                                    <a class="nav-link active" onclick="showAge();" aria-current="page"
                                        href="#">{{ getJsonLocalization('postjob', 'Age') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" onclick="showGender();"
                                        href="#">{{ getJsonLocalization('postjob', 'gender') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" onclick="showEthnicity();"
                                        href="#">{{ getJsonLocalization('postjob', 'ethnicity') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " href="#" onclick="showStatus();" tabindex="-1"
                                        aria-disabled="true">{{ getJsonLocalization('postjob', 'status') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " href="#" onclick="showLicence();" tabindex="-1"
                                        aria-disabled="true">{{ getJsonLocalization('postjob', 'Add') }}</a>
                                </li>
                            </ul>








                        </div>

                        <div id="ageFilter" class="mt-4">
                            <h5>{{ getJsonLocalization('postjob', 'Age') }}</h5>
                            <div class="row gy-3">
                                <div class="col-12 col-sm-3">
                                    <h6>{{ getJsonLocalization('postjob', 'Age Between') }}</h6>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <select style="width:50px;" class="form-control" id="startsAge">
                                        <?php
for ($v = 18; $v < 100; $v++) {
                                        ?>
                                        <option value="<?php    echo $v; ?>"><?php    echo $v; ?></option>
                                        <?php
}

                                        ?>
                                    </select>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <p>{{ getJsonLocalization('postjob', 'And') }}</p>
                                </div>
                                <div class="col-4 col-sm-3">
                                    <select style="width:50px;" class="form-control" id="endsAge">
                                        <?php
for ($v = 19; $v < 100; $v++) {
                                        ?>
                                        <option value="<?php    echo $v; ?>"><?php    echo $v; ?></option>
                                        <?php
}

                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div id="ethnicityTab" class="mt-4" style="display:none;">
                            <h5>{{ getJsonLocalization('postjob', 'Ethnicity') }}</h5>
                            <div class="row gy-3">
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="Caucasian1"
                                        id="Caucasian1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Caucasian') }}</label>
                                </div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox"
                                        name="south-asian1" id="south-asian1"><label
                                        for="male">{{ getJsonLocalization('postjob', 'south-asian') }}</label>
                                </div>
                                <div class="col-md-4"><input class="form-check-input" type="checkbox" name="Hispanic1"
                                        id="Hispanic1"><label
                                        for="male">{{ getJsonLocalization('postjob', 'Hispanic') }}</label>
                                </div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="mixed1"
                                        id="mixed1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'mixed') }}</label> </div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="African1"
                                        id="African1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'African') }}</label></div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox"
                                        name="middle-eastern1" id="middle-eastern1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'middle-eastern') }}</label>
                                </div>
                                <div class="col-md-4"><input class="form-check-input" type="checkbox" name="Afro-latin1"
                                        id="Afro-latin1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Afro-latin') }}
                                    </label> </div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="other1"
                                        id="other1"> <label for="male">{{ getJsonLocalization('postjob', 'Other') }}
                                    </label> </div>
                                <div class="col-md-4"> <input class="form-check-input" type="checkbox" name="Asian1"
                                        id="Asian1"><label for="male">{{ getJsonLocalization('postjob', 'Asian') }}
                                    </label> </div>
                                <div class="col-md-4"><input class="form-check-input" type="checkbox"
                                        name="North-african1" id="North-african1"><label
                                        for="male">{{ getJsonLocalization('postjob', 'North-african') }}
                                    </label> </div>
                                <div class="col-md-4"><input class="form-check-input" type="checkbox"
                                        name="Native_american1" id="Native_american1"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Native american') }}
                                    </label> </div>
                            </div>
                        </div>

                        <div id="status_filder" class="mt-4" style="display:none;">
                            <h5>{{ getJsonLocalization('postjob', 'Status') }}</h5>
                            <div class="row gy-3">
                                <div class="col-md-3"> <input class="form-check-input" type="radio" name="statusFilter"
                                        value="citizen" id="citizen"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'citizen') }}</label> </div>
                                <div class="col-md-5"> <input class="form-check-input" type="radio" name="statusFilter"
                                        value="permanent resident" id="permanent_resident"><label
                                        for="male">{{ getJsonLocalization('postjob', 'permanent resident') }}</label>
                                </div>
                                <div class="col-md-4"><input class="form-check-input" type="radio" name="statusFilter"
                                        value="refugee" id="refugee"><label
                                        for="male">{{ getJsonLocalization('postjob', 'refugee') }}</label> </div>
                                <div class="col-md-4"> <input class="form-check-input" type="radio" name="statusFilter"
                                        value="work visa" id="work_visa "> <label
                                        for="male">{{ getJsonLocalization('postjob', 'work visa') }} </label>
                                </div>
                                <div class="col-md-4"> <input class="form-check-input" type="radio" name="statusFilter"
                                        value="other" id="other"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Other') }}</label></div>
                            </div>
                        </div>

                        <div id="gender" class="mt-4" style="display:none;">
                            <h5>{{ getJsonLocalization('postjob', 'Gender') }}</h5>
                            <div class="row gy-3">
                                <div class="col-4"> <input class="form-check-input" type="radio" name="genderFilter"
                                        value="{{ getJsonLocalization('postjob', 'Male') }}" id="MaleFilter"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Male') }}</label> </div>
                                <div class="col-4"> <input class="form-check-input" type="radio" name="genderFilter"
                                        value="{{ getJsonLocalization('postjob', 'Female') }}" id="FemaleFilter"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Female') }}</label> </div>
                                <div class="col-4"><input class="form-check-input" type="radio" name="genderFilter"
                                        value="{{ getJsonLocalization('postjob', 'Other') }}" id="OtherFilter"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Other') }}</label> </div>
                            </div>
                        </div>

                        <div id="licence" class="mt-4" style="display:none;">
                            <h6>{{ getJsonLocalization('postjob', 'Licence and car') }}</h6>
                            <div class="row gy-3">
                                <div class="col-md-4"> <input class="form-check-input" type="radio" name="licenceFilter"
                                        value="{{ getJsonLocalization('postjob', 'Must have a car') }}" id="mustcar">
                                    <label for="male">{{ getJsonLocalization('postjob', 'Must have a car') }}</label>
                                </div>
                                <div class="col-md-8"> <input class="form-check-input" type="radio" name="licenceFilter"
                                        value="{{ getJsonLocalization('postjob', 'Must have a valid driving licence') }}"
                                        id="mustdrivinglicence"> <label
                                        for="male">{{ getJsonLocalization('postjob', 'Must have a valid driving licence') }}</label>
                                </div>
                            </div>
                        </div>

                        <script>
                            function showAge() {
                                document.getElementById("ageFilter").style.display = 'block';
                                document.getElementById("ethnicityTab").style.display = 'none';
                                document.getElementById("gender").style.display = 'none';
                                document.getElementById("status_filder").style.display = 'none';
                                document.getElementById("licence").style.display = 'none';

                            }

                            function showEthnicity() {
                                document.getElementById("ageFilter").style.display = 'none';
                                document.getElementById("ethnicityTab").style.display = 'block';
                                document.getElementById("gender").style.display = 'none';
                                document.getElementById("status_filder").style.display = 'none';
                                document.getElementById("licence").style.display = 'none';
                            }

                            function showStatus() {

                                document.getElementById("ageFilter").style.display = 'none';
                                document.getElementById("ethnicityTab").style.display = 'none';
                                document.getElementById("gender").style.display = 'none';
                                document.getElementById("status_filder").style.display = 'block';
                                document.getElementById("licence").style.display = 'none';
                            }

                            function showGender() {
                                document.getElementById("ageFilter").style.display = 'none';
                                document.getElementById("ethnicityTab").style.display = 'none';
                                document.getElementById("status_filder").style.display = 'none';
                                document.getElementById("gender").style.display = 'block';
                                document.getElementById("licence").style.display = 'none';
                            }

                            function showLicence() {
                                document.getElementById("ageFilter").style.display = 'none';
                                document.getElementById("ethnicityTab").style.display = 'none';
                                document.getElementById("status_filder").style.display = 'none';
                                document.getElementById("gender").style.display = 'none';
                                document.getElementById("licence").style.display = 'block';
                            }
                        </script>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="wf-btn wf-btn-secondary"
                            onclick="addFilter();">{{ getJsonLocalization('postjob', 'Add') }}</button>
                    </div>
                </div>
            </div>
        </div>
        <script>
            function showDialog() {
                var v = '<?php echo $jobpost; ?>';

                if (v == 'successfully') {


                    document.getElementById("showReturn").click();
                    redirect();
                }
            }
        </script>
        <div class="modal fade" id="jobsubmissionMessage" role="dialog">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="row" style="text-align: center ;">
                            <img src="logos//logo1.png" alt="" width="130" height="100" style="margin-left:30px;"><br>
                        </div>
                    </div>
                    <div class="modal-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-6" style="margin-left:28px;">
                                    <label style="color:green;">
                                        <b>
                                            <h3>{{ getJsonLocalization('postjob', 'your job offer has been posted successfully') }}
                                            </h3>
                                        </b>
                                    </label>
                                    <br><br>
                                    <form method="GET" action="{{ url('home') }}">
                                        <button type="submit" class="btn btn-warning"
                                            style="margin-left:40px;display:none;"
                                            id="redirectToMainPage">{{ getJsonLocalization('postjob', 'return to profile') }}</button>
                                    </form>
                                    <script>
                                        function redirect() {
                                            var v = '<?php echo $jobpost; ?>';

                                            setTimeout(() => {


                                                document.getElementById("redirectToMainPage").click();



                                            }, 2000);
                                        }
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Exam Modal -->
        <div class="modal fade" id="selectExamModel" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ getJsonLocalization('postjob', 'Add An Exam') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" style="max-height:400px; overflow-y:auto;">
                        <div class="text-center">
                            <img src="logos//logo1.png" alt="" width="100">
                        </div>
                        <div class="py-3 position-sticky bg-white" style="top: -16px; left: 0; z-index: 1;">
                            <input type="text" autocomplete="off" placeholder="Search for Exam" id="input" class="form-control">
                        </div>

                        <?php
$counterRow = 0;
$resultt = ExamList::get();
foreach ($resultt as $row) {
    $counterRow = $counterRow + 1;
                        ?>
                        <div class="row mt-4" id="row<?php    echo $counterRow; ?>">
                            <div class="col-3">
                                <img src="ProfileImages/exam_logos/<?php    echo $row['exam_logo_name']; ?>" alt=""
                                    width="40" height="40">
                            </div>
                            <div class="col-5 text-center"><span
                                    id="examName<?php    echo $counterRow; ?>"><?php    echo $row['exam_name']; ?></span>
                            </div>
                            <div class="col-3 text-end"><button type="button" class="wf-btn wf-btn-secondary"
                                    onclick="addExame('<?php    echo $row['exam_name']; ?>','<?php    echo $row['exam_logo_name']; ?>');">{{ getJsonLocalization('postjob', 'Add') }}</button>
                            </div>
                        </div>
                        <?php
}


                        ?>

                    </div>
                    <script>
                        var rowCounter = "<?php echo $counterRow; ?>";

                        input.oninput = function () {
                            var text = input.value;
                            for (var c = 1; c <= rowCounter; c++) {
                                document.getElementById("row" + c).style.display = 'none';
                            }
                            if (text.length == 0) {
                                for (var c = 1; c <= rowCounter; c++) {
                                    document.getElementById("row" + c).style.display = 'flex';
                                }
                            }

                            if (text.length > 0) {
                                for (var c = 1; c <= rowCounter; c++) {
                                    var SearchText = document.getElementById("examName" + c).innerHTML;
                                    SearchText = SearchText.toLowerCase();
                                    text = text.toLowerCase();
                                    if (SearchText.includes(text)) {
                                        document.getElementById("row" + c).style.display = 'flex';

                                    }
                                }
                            }

                        };
                    </script>

                </div>
            </div>
        </div>
    </section>

    <script>
        var examListName = [];



        function addExame(examName, logoName) {

            $('#selectExamModel').modal('hide');
            examListName.push(examName);


            //    document.getElementById("examModelCloseButton").click();
            let newbtn = document.createElement("appendText");
            var image = document.createElement("img");
            image.style.width = '40px';
            image.style.height = '40px';
            image.setAttribute("src", 'ProfileImages/exam_logos/' + logoName);
            newbtn.appendChild(image);
            var elem2 = document.createElement('label');
            elem2.innerHTML = " " + examName;
            var oldExamValue = "";
            for (var s = 0; s < examListName.length; s++) {
                if (oldExamValue.length == 0) {
                    oldExamValue = examListName[s];
                } else {
                    oldExamValue = oldExamValue + "," + examListName[s];
                }
            }

            document.getElementById("examDetail").value = oldExamValue;
            newbtn.appendChild(elem2);
            let xspan = document.createElement('span');
            xspan.innerHTML =
                '<sup style="margin-left:0px;"><a href="javascript:FunctionCall();" style="margin-left:5px;margin-top:px;"><b>X<b></a></sup><br>'; //this gives it superscript text
            xspan.id = 'close'; //this was not necessary but it is nice to have
            xspan.onclick = function () {
                oldExamValue = "";
                var appendTxx = newbtn.innerHTML;
                for (var s = 0; s < examListName.length; s++) {
                    if (appendTxx.indexOf(examListName[s]) === -1) {
                        oldExamValue = oldExamValue + "," + examListName[s];
                    }
                }

                document.getElementById("examDetail").value = oldExamValue;
                newbtn.remove();


                br.remove();
            };
            newbtn.appendChild(xspan);
            document.getElementById("myDIV").appendChild(newbtn);
            var br = document.createElement("br");




        }
    </script>
    <script>
        var tabCounter = 1;

        function nextTab() {
            document.getElementById("submitForm").style.display = 'none';
            tabCounter = tabCounter + 1;



            //checking if in frist tab data enter correct...............
            if (tabCounter == 2) {


                if (document.getElementById("job_title").value.length == 0) {
                    tabCounter = 1;
                    alert("Title of the jobs can not be Null");
                    return false;
                }
                // if (document.getElementById("field").value.length == 0) {
                //     tabCounter = 1;
                //     alert("Select Field Value");
                //     return false;
                // }
                if (document.getElementById("country_name").value.length == 0) {
                    tabCounter = 1;
                    alert("Select Country Name");
                    return false;
                }

                if (document.getElementById("city_name").value.length == 0) {
                    tabCounter = 1;
                    alert("Select City Name");
                    return false;
                }
                if (document.getElementById("address").value.length == 0) {
                    tabCounter = 1;
                    alert("Enter Address Value");
                    return false;
                }

                if (document.getElementById("customFile").files.length == 0) {
                    tabCounter = 1;
                    alert("Select Job Offer Picture");
                    return false;
                }

            }
            //.....................................................................
            if (tabCounter == 3) {
                if (document.getElementById("description").value.length == 0) {
                    tabCounter = 2;
                    alert("Description Field can not be Null");
                    return false;
                }
                if (document.getElementById("requirement").value.length == 0) {
                    tabCounter = 2;
                    alert("Requirement Field can not be Null");
                    return false;
                }
                if (document.getElementById("Task").value.length == 0) {
                    tabCounter = 2;
                    alert("Task Field can not be Null");
                    return false;
                }

            }
            if (tabCounter == 4) {
                if (document.getElementById("schedule").value.length == 0) {
                    tabCounter = 3;
                    alert("Select Schedule Filed ");
                    return false;
                }
                if (document.getElementById("salary").value.length == 0) {
                    tabCounter = 3;
                    alert("Enter Salary For Job ");
                    return false;
                }
                if (document.getElementById("mode").value.length == 0) {
                    tabCounter = 3;
                    alert("Select Mode Field");
                    return false;
                }
                if (document.getElementById("duration").value.length == 0) {
                    tabCounter = 3;
                    alert("Select Duration Field");
                    return false;
                }
                if (document.getElementById("driver_license").value.length == 0) {
                    tabCounter = 3;
                    alert("Select Driver License Field");
                    return false;
                }
                if (document.getElementById("car").value.length == 0) {
                    tabCounter = 3;
                    alert("Select Car Field");
                    return false;
                }
            }

            if (tabCounter == 5) {
                let startAgeV = parseInt(document.getElementById("candiateAgeStart").value);
                let endAgeV = parseInt(document.getElementById("candiateAgeEnd").value);

                // if (startAgeV == 0) {
                //     tabCounter = 4;
                //     alert("Age Field Value Should be Greater Then 0");
                //     return false;
                // }
                // if (endAgeV == 0) {
                //     tabCounter = 4;
                //     alert("Age Field Value Should be Greater Then 0");
                //     return false;
                // }

                if (startAgeV > endAgeV) {
                    tabCounter = 4;
                    alert("Age Between Filed Should Be In Range From 1 To 99");
                    return false;
                }


                let genderSelected = false;
                if (document.getElementById('male').checked) {
                    genderSelected = true;
                }
                if (document.getElementById('female').checked) {
                    genderSelected = true;
                }
                if (document.getElementById('other').checked) {
                    genderSelected = true;
                }
                if (document.getElementById('all').checked) {
                    genderSelected = true;
                }

                if (genderSelected == false) {
                    tabCounter = 4;
                    alert("Select Gender Field");
                    return false;
                }

                //         let ethnicity = false;
                //         if (document.getElementById('caucasian').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('north_african').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('african').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Hispanic').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Asian').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Afro-latin').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('South-asian').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Native-american').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Middle-eastern').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('Other').checked) {
                //             ethnicity = true;
                //         }
                //         if (document.getElementById('alleth').checked) {
                //             ethnicity = true;
                //         }

                //         if (ethnicity == false) {
                //             tabCounter = 4;
                //             alert("Select Ethnicity Field");
                //             return false;
                //         }
            }


            if (tabCounter == 8) {
                tabCounter = 7;

            }
            if (tabCounter == 2) {



                document.getElementById("PrevousButtons").style.display = 'block';

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'block';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
                document.getElementById("submitForm").style.display = 'none';

            }
            if (tabCounter == 3) {



                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'block';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
                document.getElementById("submitForm").style.display = 'none';
            }
            if (tabCounter == 4) {




                document.getElementById("submitForm").style.display = 'none';
                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'block';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 5) {


                // alert('here in tab 5');
                document.getElementById("submitForm").style.display = 'none';
                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'block';
                document.getElementById("tab7").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
            }
            if (tabCounter == 6) {
                document.getElementById("submitForm").style.display = 'none';

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'block';
                document.getElementById("tab7").style.display = 'none';
                document.getElementById("nextButtonOption").innerHTML = 'Finish';
            }

            if (tabCounter == 7) {


                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'block';
                document.getElementById("nextButtonOption").style.display = 'none';
                document.getElementById("nextButtonDiv").style.display = 'none';
                document.getElementById("submitForm").style.display = 'flex';
                showFinalDetail();

            }

        }

        function previousTab() {
            document.getElementById("nextButtonOption").innerHTML = 'Next';
            document.getElementById("nextButtonOption").style.display = 'block';
            document.getElementById("nextButtonDiv").style.display = 'block';
            document.getElementById("submitForm").style.display = 'none';
            tabCounter = tabCounter - 1;

            if (tabCounter == 0) {
                tabCounter = 1;
                document.getElementById("PrevousButton").style.display = 'none';
            }
            if (tabCounter == 1) {

                document.getElementById("tab1").style.display = 'block';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 2) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'block';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 3) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'block';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 4) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'block';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 5) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'block';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';
            }
            if (tabCounter == 6) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'block';
                document.getElementById("tab7").style.display = 'none';
            }

            if (tabCounter == 7) {

                document.getElementById("tab1").style.display = 'none';
                document.getElementById("tab2").style.display = 'none';
                document.getElementById("tab3").style.display = 'none';
                document.getElementById("tab4").style.display = 'none';
                document.getElementById("tab5").style.display = 'none';
                document.getElementById("tab6").style.display = 'none';
                document.getElementById("tab7").style.display = 'none';

            }
        }

        function showFinalDetail() {

            document.getElementById('job_titless').innerHTML = document.getElementById('job_title').value;
            document.getElementById('field_show').innerHTML = document.getElementById('field').value;
            document.getElementById('address_show').innerHTML = document.getElementById('address').value;

            //reading textarea line byline here
            var lines = document.getElementById('description').value.split('\n');
            for (var i = 0; i < lines.length; i++) {
                if (i == 0) {
                    document.getElementById('job_des').innerHTML = lines[i];
                } else {
                    document.getElementById('job_des').innerHTML = document.getElementById('job_des').innerHTML + '<br>' +
                        lines[i];
                }

            }
            //  document.getElementById('job_des').innerHTML=document.getElementById('description').value;
            lines = document.getElementById('requirement').value.split('\n');
            for (var i = 0; i < lines.length; i++) {
                if (i == 0) {
                    document.getElementById('job_Req').innerHTML = lines[i];
                } else {
                    document.getElementById('job_Req').innerHTML = document.getElementById('job_Req').innerHTML + '<br>' +
                        lines[i];
                }

            }


            //document.getElementById('job_Req').innerHTML=document.getElementById('requirement').value;

            lines = document.getElementById('Task').value.split('\n');
            for (var i = 0; i < lines.length; i++) {
                if (i == 0) {
                    document.getElementById('job_Task').innerHTML = lines[i];
                } else {
                    document.getElementById('job_Task').innerHTML = document.getElementById('job_Task').innerHTML + '<br>' +
                        lines[i];
                }

            }

            //document.getElementById('job_Task').innerHTML=document.getElementById('Task').value;
            document.getElementById('job_Schedule').innerHTML = document.getElementById('schedule').value;
            document.getElementById('job_mode').innerHTML = document.getElementById('mode').value;
            document.getElementById('job_driver_license').innerHTML = document.getElementById('driver_license').value;
            document.getElementById('job_car').innerHTML = document.getElementById('car').value;

            var examV = document.getElementById('examDetail').value;

            const examArray = examV.split("::");
            var examD = "";
            for (var k = 1; k < examArray.length; k++) {
                if (examD.length > 0) {
                    examD = examD + "," + examArray[k];
                } else {
                    examD = examArray[k];
                }
            }

            document.getElementById('workfrater_exam').innerHTML = examD;
            document.getElementById('job_age').innerHTML = "Between " + document.getElementById('candiateAgeStart').value +
                " and " + document.getElementById('candiateAgeEnd').value;

            var ele = document.getElementsByName('genders');

            for (i = 0; i < ele.length; i++) {
                if (ele[i].checked) {

                    document.getElementById('job_sex').innerHTML = ele[i].value;
                }
            }

            var data = '';
            if (document.getElementById('caucasian').checked == true) {

                data = data + 'caucasian ,';
            }
            if (document.getElementById('north_african').checked == true) {
                data = data + 'north_african ,';
            }
            if (document.getElementById('african').checked == true) {
                data = data + 'african ,';
            }
            if (document.getElementById('Hispanic').checked == true) {
                data = data + 'Hispanic ,';
            }
            if (document.getElementById('Asian').checked == true) {
                data = data + 'Asian ,';
            }
            if (document.getElementById('Afro-latin').checked == true) {
                data = data + 'Afro-latin ,';
            }
            if (document.getElementById('South-asian').checked == true) {
                data = data + 'South-asian ,';
            }
            if (document.getElementById('Native-american').checked == true) {
                data = data + 'Native-american ,';
            }
            if (document.getElementById('Middle-eastern').checked == true) {
                data = data + 'Middle-eastern ,';
            }
            if (document.getElementById('Other').checked == true) {
                data = data + 'Other ,';
            }
            if (document.getElementById('all').checked == true) {
                data = data + 'all ,';
            }
            document.getElementById('job_Ethnicity').innerHTML = data;


        }
    </script>
    <script>

        function PreviewImage() {
            var fileName = document.getElementById('customFile').value;

            if (fileName.includes(".png") || fileName.includes(".jpg") || fileName.includes(".jpeg")) {
                var oFReader = new FileReader();
                oFReader.readAsDataURL(document.getElementById("customFile").files[0]);

                oFReader.onload = function (oFREvent) {

                    document.getElementById("profile_img1").src = oFREvent.target.result;
                    document.getElementById("profile_img2").src = oFREvent.target.result;
                };
            } else {
                document.getElementById('customFile').value = null;
            }



        };

        function addFilter() {
            document.getElementById("filterList").value = "";
            const myNode = document.getElementById("myDIVFilter");
            myNode.innerHTML = '';

            var sAge = document.getElementById("startsAge").value;
            var eAge = document.getElementById("endsAge").value;
            document.getElementById("startAge").value=sAge;
            document.getElementById("endAge").value=eAge;

            var b = parseInt(eAge);
            if (b > 0) {
                let newbtn = document.createElement("appendText");
                var elem2 = document.createElement('label');
                elem2.innerHTML = "age:" + sAge + " and " + eAge;
                var oldV = document.getElementById("filterList").value;
                if (oldV.length == 0) {
                    oldV = elem2.innerHTML;
                } else {
                    oldV = oldV + ":-" + elem2.innerHTML;
                }

                document.getElementById("filterList").value = oldV;
                newbtn.appendChild(elem2);
                document.getElementById("myDIVFilter").appendChild(newbtn);
                var br = document.createElement("br");
                document.getElementById("myDIVFilter").appendChild(br);
            }

            var ethnicityData = "";
            if (document.getElementById("Caucasian1").checked == true) {


                ethnicityData = ethnicityData + "Caucasian, ";

            }
            if (document.getElementById("south-asian1").checked == true) {
                ethnicityData = ethnicityData + "south-asian, ";
            }
            if (document.getElementById("Hispanic1").checked == true) {
                ethnicityData = ethnicityData + "Hispanic, ";
            }
            if (document.getElementById("mixed1").checked == true) {
                ethnicityData = ethnicityData + "mixed, ";
            }
            if (document.getElementById("African1").checked == true) {
                ethnicityData = ethnicityData + "African, ";
            }
            if (document.getElementById("middle-eastern1").checked == true) {
                ethnicityData = ethnicityData + "middle-eastern, ";
            }
            if (document.getElementById("Afro-latin1").checked == true) {
                ethnicityData = ethnicityData + "Afro-latin, ";
            }
            if (document.getElementById("other1").checked == true) {
                ethnicityData = ethnicityData + "other, ";
            }
            if (document.getElementById("Asian1").checked == true) {
                ethnicityData = ethnicityData + "Asian, ";
            }
            if (document.getElementById("North-african1").checked == true) {
                ethnicityData = ethnicityData + "North-african, ";
            }

            if (document.getElementById("Native_american1").checked == true) {
                ethnicityData = ethnicityData + "Native american, ";
            }
                document.getElementById("entList").value=ethnicityData;
            if (ethnicityData.length > 3) {

                let newbtn = document.createElement("appendText");
                var elem3 = document.createElement('label');
                elem3.innerHTML = "Ethnicity: " + ethnicityData;
                newbtn.appendChild(elem3);
                document.getElementById("myDIVFilter").appendChild(newbtn);
                var br = document.createElement("br");
                document.getElementById("myDIVFilter").appendChild(br);


                var oldV = document.getElementById("filterList").value;
                oldV = oldV + ":-" + elem3.innerHTML;
                document.getElementById("filterList").value = oldV;
                document.getElementById('job_Ethnicity').innerHTML = elem3.innerHTML;

            }

            var ele = document.getElementsByName('genderFilter');

            for (i = 0; i < ele.length; i++) {
                if (ele[i].checked) {
                    let newbtn = document.createElement("appendText");
                    var elem3 = document.createElement('label');
                    elem3.innerHTML = "Gender: " + ele[i].value;
                    document.getElementById("genderSelected").value=ele[i].value;
                    var oldV = document.getElementById("filterList").value;

                    if (oldV.length == 0) {
                        oldV = elem3.innerHTML;
                    } else {
                        oldV = oldV + ":-" + elem3.innerHTML;
                    }
                    document.getElementById("filterList").value = oldV;

                    newbtn.appendChild(elem3);
                    document.getElementById("myDIVFilter").appendChild(newbtn);
                    var br = document.createElement("br");
                    document.getElementById("myDIVFilter").appendChild(br);


                }
            }
            ele = document.getElementsByName('statusFilter');
            for (i = 0; i < ele.length; i++) {
                if (ele[i].checked) {
                    let newbtn = document.createElement("appendText");
                    var elem3 = document.createElement('label');
                    elem3.innerHTML = "Status: " + ele[i].value;
                    document.getElementById("status").value=ele[i].value;
                    var oldV = document.getElementById("filterList").value;
                    if (oldV.length == 0) {
                        oldV = elem3.innerHTML;
                    } else {
                        oldV = oldV + ":-" + elem3.innerHTML;
                    }
                    document.getElementById("filterList").value = oldV;
                    newbtn.appendChild(elem3);
                    document.getElementById("myDIVFilter").appendChild(newbtn);
                    var br = document.createElement("br");
                    document.getElementById("myDIVFilter").appendChild(br);


                }
            }
            ele = document.getElementsByName('licenceFilter');
            for (i = 0; i < ele.length; i++) {
                if (ele[i].checked) {
                    let newbtn = document.createElement("appendText");
                    var elem3 = document.createElement('label');
                    elem3.innerHTML = "Licence and Car : " + ele[i].value;
                    document.getElementById("carvslicenance").value=ele[i].value;
                    var oldV = document.getElementById("filterList").value;
                    if (oldV.length == 0) {
                        oldV = elem3.innerHTML;
                    } else {
                        oldV = oldV + ":-" + elem3.innerHTML;
                    }
                    document.getElementById("filterList").value = oldV;
                    newbtn.appendChild(elem3);
                    document.getElementById("myDIVFilter").appendChild(newbtn);
                    var br = document.createElement("br");
                    document.getElementById("myDIVFilter").appendChild(br);


                }
            }

            $('#addFilderModel').modal('hide');
        }

        function scrollToBottomAuto() {

            var refreshIntervalId = setInterval(function () {
                //resizeComponents();

                var sc = document.getElementById('MessageHistory1');
                sc.scrollTop = sc.scrollHeight;
                sc = document.getElementById('MessageHistory2');
                sc.scrollTop = sc.scrollHeight;
                sc = document.getElementById('MessageHistory1');
                sc.scrollTop = sc.scrollHeight;
                const element = document.getElementById('ChatModel1');

                element.scrollTop = element.scrollHeight;



                clearInterval(refreshIntervalId);

            }, 1000);
        }
    </script>

</body>

@include('checkvideocallstatus')
@include('messageAjaxHomePage')

</html>