<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Professional Network | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('professional-network', 'join_network') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('professional-network', 'platform_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('professional-network', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('professional-network', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img8.jpg" class="banner-img" alt="{{ getJsonLocalization('professional-network', 'banner_image_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="section-padding bg-primary text-white">
        <div class="container">
            <div class="container-medium px-0 text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                {{ getJsonLocalization('professional-network', 'platform_description_detailed') }}
            </div>
        </div>
    </section>

    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('professional-network', 'basic_functionalities') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('professional-network', 'intro_description') }}</p>
                </div>
            </div>
            <div class="row gy-3 justify-content-center">
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/1.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'messages_title') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'messages_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/2.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'video_calls_title') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'video_calls_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/3.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'posts_interactions_title') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'posts_interactions_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('professional-network', 'title') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('professional-network', 'description') }}</p>
                </div>
            </div>
            <div class="row gy-3 justify-content-center">
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/4.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'online_interviews_for_your_candidate') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'online_interviews_for_your_candidate_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/4.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'online_interviews_for_non_registered_candidates') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'online_interviews_for_non_registered_candidates_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/5.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'online_exams_for_your_candidate') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'online_exams_for_your_candidate_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/5.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'online_exam_for_non_registered_candidates') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'online_exam_for_non_registered_candidates_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/6.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'filter_message_and_job_applications') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'filter_message_and_job_applications_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/professional-network-icons/5.png" class="card-icon" alt="img">
                        <div class="filter-card-body">
                            <h5 class="card-title">{{ getJsonLocalization('professional-network', 'record_your_interviews') }}</h5>
                            <div class="description">
                                <p>{{ getJsonLocalization('professional-network', 'record_your_interviews_desc') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white overflow-hidden">
    <div class="container">
        <div class="section-title-area text-center mx-auto">
            <h2 class="text-center mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('professional-network', 'functionalities_for_individuals') }}</h2>
            <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <p>{{ getJsonLocalization('professional-network', 'workfrater_is_the_ideal_platform') }}</p>
            </div>
        </div>
        <div class="row gy-3 justify-content-center">
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/8.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'complete_online_exams') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'complete_online_exams_desc') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/9.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'complete_online_interviews') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'complete_online_interviews_desc') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/10.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'increased_visibility') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'increased_visibility_desc') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="section-padding bg-white overflow-hidden">
    <div class="container">
        <div class="section-title-area text-center mx-auto">
            <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('professional-network', 'functionalities_for_education_institution') }}</h2>
            <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <p>{{ getJsonLocalization('professional-network', 'schools_are_increasingly_using_online_classrooms') }}</p>
            </div>
        </div>
        <div class="row gy-3 justify-content-center">
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/4.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'online_interviews_for_your_candidates') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'automated_interview_with_relevant_questions') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/11.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'record_classes') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'students_can_join_virtual_classroom') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/12.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'record_students') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'ensure_students_remain_focused') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/13.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'sharing_space') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'dedicated_space_for_sharing_files') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="filter-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/icons/professional-network-icons/14.png" class="card-icon" alt="img">
                    <div class="filter-card-body">
                        <h5 class="card-title">{{ getJsonLocalization('professional-network', 'exams') }}</h5>
                        <div class="description">
                            <p>{{ getJsonLocalization('professional-network', 'create_exams_for_your_students') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
