<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Search For An Online Test | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('search-an-online-test', 'search_title') }}</h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('search-an-online-test', 'search_description') }}</h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">{{ getJsonLocalization('search-an-online-test', 'sign_up') }}</a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">{{ getJsonLocalization('search-an-online-test', 'contact') }}</a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img3.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>



    <!-- Search for exam section -->
    <section class="section-padding bg-lightgrey position-relative text-white">
        <div class="bg-video-layer">
            <video src="{{ URL::to('/') }}/videos//coding-video.mp4" autoplay loop muted></video>
        </div>
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'Search for an exam rapidly') }}</h2>
            </div>
            <div class="container-large px-0">
                <form id="searchjobs" class="mb-4 mb-md-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" action="{{ route('viewjobs') }}" method="get">
                    <div class="row gx-2 gx-md-4 gy-3 justify-content-center">
                        <div class="col-sm-6 col-md-3 position-relative">
                            <input type="text" class="form-select exam_search" id="exam_search" name="exam_search" placeholder="{{ getJsonLocalization('index', 'exam') }}" onkeyup="suggestSearch(this.value)" />
                            <div id="result" class="list-group suggested-search position-absolute w-100"></div>
                        </div>
                        <div class="col-sm-6 col-md-3"><button type="submit" class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'search') }}</button></div>
                    </div>
                </form>
            </div>
            <div class="slider-box">
                <div class="wf-logo-slider">
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/angular.png" class="single-logo" alt="img" />
                            <h6>Angular</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/aws.png" class="single-logo" alt="img" />
                            <h6>AWS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/azure.png" class="single-logo" alt="img" />
                            <h6>Azure</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/html.png" class="single-logo" alt="img" />
                            <h6>HTML</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/css.png" class="single-logo" alt="img" />
                            <h6>CSS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/bootstrap.png" class="single-logo" alt="img" />
                            <h6>Bootstrap</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/java.png" class="single-logo" alt="img" />
                            <h6>Java</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/javascript.png" class="single-logo" alt="img" />
                            <h6>Javascript</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/jquery.png" class="single-logo" alt="img" />
                            <h6>JQuery</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/laravel.png" class="single-logo" alt="img" />
                            <h6>Laravel</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/mysql.png" class="single-logo" alt="img" />
                            <h6>MySql</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/next-js.png" class="single-logo" alt="img" />
                            <h6>Next JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/node-js.png" class="single-logo" alt="img" />
                            <h6>Node JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/php.png" class="single-logo" alt="img" />
                            <h6>PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/python.png" class="single-logo" alt="img" />
                            <h6>Python</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/react.png" class="single-logo" alt="img" />
                            <h6>React</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ruby.png" class="single-logo" alt="img" />
                            <h6>Ruby</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/3ds-max.png" class="single-logo" alt="img" />
                            <h6>3DS Max</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-ai.png" class="single-logo" alt="img" />
                            <h6>Adobe AI</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-fr.png" class="single-logo" alt="img" />
                            <h6>Adobe FR</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-lightroom.png" class="single-logo" alt="img" />
                            <h6>Adobe LI</h6>
                        </div>
                    </div><div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/alibaba.png" class="single-logo" alt="img" />
                            <h6>Alibaba</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/autocad-2d.png" class="single-logo" alt="img" />
                            <h6>Autocad 2D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/autocad-3d.png" class="single-logo" alt="img" />
                            <h6>Autocad 3D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/c.png" class="single-logo" alt="img" />
                            <h6>C</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/caffe.png" class="single-logo" alt="img" />
                            <h6>Caffe</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cake-php.png" class="single-logo" alt="img" />
                            <h6>Cake PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cinema-4d.png" class="single-logo" alt="img" />
                            <h6>Cinema 4D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cntk.png" class="single-logo" alt="img" />
                            <h6>CNTK</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/codeignetor.png" class="single-logo" alt="img" />
                            <h6>Codeignetor</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cryengine.png" class="single-logo" alt="img" />
                            <h6>Cryengine</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ember.png" class="single-logo" alt="img" />
                            <h6>Ember</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/Excel.png" class="single-logo" alt="img" />
                            <h6>Excel</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/Express-js.png" class="single-logo" alt="img" />
                            <h6>Express JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/fasion-360.png" class="single-logo" alt="img" />
                            <h6>Fasion 360</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/figma.png" class="single-logo" alt="img" />
                            <h6>Figma</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/fuel-php.png" class="single-logo" alt="img" />
                            <h6>Fuel PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/google-cloud.png" class="single-logo" alt="img" />
                            <h6>Google Cloud</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ibm-cloud.png" class="single-logo" alt="img" />
                            <h6>IBM Cloud</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/jason.png" class="single-logo" alt="img" />
                            <h6>Jason</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/kearas.png" class="single-logo" alt="img" />
                            <h6>Kearas</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/mathematica.png" class="single-logo" alt="img" />
                            <h6>Mathematica</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/matlab.png" class="single-logo" alt="img" />
                            <h6>Matlab</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/nosql.png" class="single-logo" alt="img" />
                            <h6>NoSql</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/oracle.png" class="single-logo" alt="img" />
                            <h6>Oracle</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/phalcon.png" class="single-logo" alt="img" />
                            <h6>Phalcon</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    <!-- Online Tests section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('search-an-online-test', 'online_tests_title') }}</h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('search-an-online-test', 'online_tests_description') }}</p>
                </div>
            </div>
            <div class="services-boxes-container mx-auto">
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/1.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'programming_languages') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/2.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'three_d_engine') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/3.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'ai_machine_learning') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/4.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'databases') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/6.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'cybersecurity') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/7.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'video_editing') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/8.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'adobe_suite') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/9.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'music_sound') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/10.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'languages') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/11.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'office_softwares') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/12.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'javascript_frameworks') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/13.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'java_frameworks') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/14.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'php_frameworks') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/15.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'c_sharp_frameworks') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/16.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'wordpress_frameworks') }}</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/online-tests-icons/17.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">{{ getJsonLocalization('search-an-online-test', 'python_frameworks') }}</h6>
                </a>
            </div>
        </div>
    </section>


    <!-- Exams Icons section -->
    <section class="section-padding bg-white border-top overflow-hidden bg-lightgrey">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('search-an-online-test', 'most_popular_online_tests') }}</h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'our most popular tests - desc') }}</p>
                </div>
            </div>
            <div class="services-boxes-container mx-auto">
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/python.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Python</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/javascript.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Javascript</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/html.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">HTML</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/css.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">CSS</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/php.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">PHP</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/c-sharp.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">C Sharp</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/java.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">JAVA</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/c++.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">C++</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/swift.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Swift</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/ruby.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Ruby</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/dart.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Dart</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/go.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Go</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/kotlin.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Kotlin</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/maya.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Maya</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/unreal-engine4.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Unreal Engine</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/blender.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Blender</h6>
                </a>
            </div>
        </div>
    </section>

    <!-- Alternative rows section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('search-an-online-test', 'how_tests_work') }}</h2>
                <div class="description wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('search-an-online-test', 'platform_features') }}</p>
                </div>
            </div>
            <div class="alternative-rows-container">
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'recorded_screen_and_webcam') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'recording_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img2.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'diversified_questions') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'diversified_questions_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img3.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'diversified_exams') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'diversified_exams_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img4.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'advanced_user_interface') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'advanced_user_interface_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>    
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img5.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'easy_access') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'easy_access_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img6.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'many_levels_of_tests') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'many_levels_of_tests_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img7.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'reports') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'reports_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img8.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'availability') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'availability_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img9.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('search-an-online-test', 'personalization') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('search-an-online-test', 'personalization_description') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('search-an-online-test', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/how-test-works-img10.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
