<?php


?>
<!DOCTYPE html>
<html lang="en">

<head>
   <!-- links and scripts -->
   <title>Workfrater</title>
   <meta charset="utf-8">
   <meta name="csrf-token" content="{{ csrf_token() }}">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
   <link rel="stylesheet" href="css/utils.css">
   <link rel="stylesheet" href="css/ui-elements.css">
   <link rel="stylesheet" href="css/bootstrap-overrides.css">
   <link rel="stylesheet" href="css/home.css">
   <link rel="stylesheet" href="css/index.css">
   <link rel="stylesheet" href="css/responsive.css">

   <script src="js/jquery.min.js"></script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

   <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
   <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
   <script src="js/countrypicker.js"></script>

   <script type="text/javascript" src="js/custom.js"></script>
   <script type="text/javascript" src="js//url.js"></script>
   <script>
      function openaditionalInformation() {

         window.location.href = "aditionalInformation.php";

      }
   </script>
</head>

<body>
   @include('header')
   <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
      <div class="container">
         <div class="form-box mx-auto">
            <div class="text-center mb-5">
               <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
            </div>
            <h4>{{ getJsonLocalization('signup', 'Work experience') }}</h4>
            <p>{{ getJsonLocalization('signup', 'Please indicate your work experience from the most recent to the oldest') }}</p>
            <div class="diplomas-box" id="myDIV"> </div>
            <fieldset>
               <div id="addRow" name="addRow" style="display:none">
                  <div class="row gy-2 mt-4">
                     <div class="col-12">
                        <label class="text-mini">{{ getJsonLocalization('signup', 'Job Title') }}:</label>
                        <input type="text" class="form-control" id="job_title1" name="job_title1" value="">
                     </div>
                     <div class="col-12">
                        <label class="text-mini">{{ getJsonLocalization('signup', 'Company') }}:</label>
                        <input type="text" class="form-control" id="company_name1" name="company_name1" value="">
                     </div>
                     <div class="col-md-6">
                        <label class="text-mini">{{ getJsonLocalization('signup', 'From Year') }}:</label>

                        <select class="form-select" style="height:40px;background-color:white;" id="year_from1" name="year_from1">
                           <option value="" disabled selected>Year{{ getJsonLocalization('signup', 'Year') }}</option>
                           <?php
                           $year = (int)date("Y");
                           for ($i = 0; $i < 104; $i++) {
                              $yearr = $year - $i;
                           ?>
                              <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                           <?php
                           }
                           ?>
                        </select>



                     </div>
                     <div class="col-md-6">
                        <label class="text-mini">{{ getJsonLocalization('signup', 'To Year') }}:</label>
                        <select class="form-select" style="height:40px;background-color:white;" id="year_to1" name="year_to1">
                           <option value="" disabled selected>Year</option>
                           <?php
                           $year = (int)date("Y");
                           for ($i = 0; $i < 104; $i++) {
                              $yearr = $year - $i;
                           ?>
                              <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                           <?php
                           }
                           ?>
                        </select>
                     </div>
                     <div class="col-12">
                        <label class="text-mini">{{ getJsonLocalization('signup', 'Still Working') }}:</label>
                        <input class="form-check-input" type="checkbox" value="" id="stillworking" onclick="stillWorking();">
                     </div>
                  </div>
               </div>

               <div class="row mt-4" id="buttonAddRec" name="buttonAddRec" style="visibility:hidden;">
                  <div class="col-6">
                     <button type="button" class="wf-btn wf-btn-danger" onclick="cancelRec();">{{ getJsonLocalization('signup', 'Cancel') }}</button>
                  </div>
                  <div class="col-6 text-end">
                     <button type="button" class="wf-btn wf-btn-success" onclick="takeValues();">{{ getJsonLocalization('signup', 'Add') }}</button>
                  </div>
               </div>





               <div>
                  <div class="text-center">
                     <button type="button" class="wf-btn wf-btn-primary" onclick="showRow();" id="addExpButton" name="addExpButton"><img src="ProfileImages/icons/addsocaillink.png" style="width:20px;" alt="add icon">{{ getJsonLocalization('signup', 'Add work experience') }}</button>
                  </div>



                  <br>
                  <form action="{{route('action_adding_exp')}}" method="POST">
                     @csrf
                     <input type="hidden" id="job_title_1" name="job_title_1">
                     <input type="hidden" id="job_title_2" name="job_title_2">
                     <input type="hidden" id="job_title_3" name="job_title_3">
                     <input type="hidden" id="company_name_1" name="company_name_1">
                     <input type="hidden" id="company_name_2" name="company_name_2">
                     <input type="hidden" id="company_name_3" name="company_name_3">
                     <input type="hidden" id="year_from_1" name="year_from_1">
                     <input type="hidden" id="year_from_2" name="year_from_2">
                     <input type="hidden" id="year_from_3" name="year_from_3">
                     <input type="hidden" id="year_to_1" name="year_to_1">
                     <input type="hidden" id="year_to_2" name="year_to_2">
                     <input type="hidden" id="year_to_3" name="year_to_3">
                     <div class="row">
                        <div class="col-6">
                           <a href="{{route('signup3')}}" type="button" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Go Back') }}</a>
                        </div>

                        <div class="col-6 text-end">
                           <button type="submit" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Next') }}</button>
                        </div>
                     </div>
               </div>
               </form>

            </fieldset>

         </div>
   </section>
   <script>
      var rowCount = 0;
      var getValue = 0;
      var dataListArray = [];

      function stillWorking() {
         if (document.getElementById("stillworking").checked == true) {
            document.getElementById('year_to1').value = null;
            document.getElementById('year_to1').style.display = 'none';
         } else if (document.getElementById("stillworking").checked == false) {
            document.getElementById('year_to1').value = null;
            document.getElementById('year_to1').style.display = 'block';
         }
      }

      function cancelRec() {

         document.getElementById('addRow').style.display = 'none';
         document.getElementById('buttonAddRec').style.visibility = 'hidden';
         document.getElementById('addExpButton').style.visibility = 'visible';



      }

      function showRow() {

         document.getElementById("stillworking").checked = false;
         document.getElementById('year_to1').style.display = 'block';
         document.getElementById('addRow').style.display = 'block';
         document.getElementById('buttonAddRec').style.visibility = 'visible';
         document.getElementById('addExpButton').style.visibility = 'hidden';

      }

      function FunctionCall() {

      }

      function takeValues() {


         if (dataListArray.length == 3) {
            alert("You Can Add Max 3 Record");
            return;
         }
         let i = 0;
         document.getElementById("myDIV").innerHTML = '';

         if (getValue == 0) {
            var jobTitle = document.getElementById('job_title1').value;
            var companyName = document.getElementById('company_name1').value;
            var yearFrom = document.getElementById('year_from1').value;
            var yearTo = document.getElementById('year_to1').value;
            if (!jobTitle) {
               alert("Please Add Job Title");
               return;
            }
            if (!companyName) {
               alert("Please Add Company Name");
               return;
            }
            if (!yearFrom) {
               alert("Please Add Year From");
               return;
            }

            if (!yearTo) {



               if (document.getElementById("stillworking").checked == true) {
                  yearTo = "now";
                  document.getElementById("stillworking").checked = false;
               } else {

                  alert("Please Add Year To");
                  return;
               }
            }

            dataListArray.push(companyName + ',            ' + jobTitle + '            ' + yearFrom + '-' + yearTo);
         }

         document.getElementById('job_title_1').value = null;
         document.getElementById('company_name_1').value = null;
         document.getElementById('year_from_1').value = null;
         document.getElementById('year_to_1').value = null;

         document.getElementById('job_title_2').value = null;
         document.getElementById('company_name_2').value = null;
         document.getElementById('year_from_2').value = null;
         document.getElementById('year_to_2').value = null;

         document.getElementById('job_title_3').value = null;
         document.getElementById('company_name_3').value = null;
         document.getElementById('year_from_3').value = null;
         document.getElementById('year_to_3').value = null;

         while (i < dataListArray.length) {
            var v = i + 1;

            if (v == 1) {

               const myArray = dataListArray[i].split("            ");
               document.getElementById('job_title_1').value = myArray[1];
               document.getElementById('company_name_1').value = myArray[0];
               var vvv = myArray[2];
               const myArray2 = vvv.split("-");
               document.getElementById('year_from_1').value = myArray2[0];
               document.getElementById('year_to_1').value = myArray2[1];
            }
            if (v == 2) {

               const myArray = dataListArray[i].split("            ");
               document.getElementById('job_title_2').value = myArray[1];
               document.getElementById('company_name_2').value = myArray[0];
               var vvv = myArray[2];
               const myArray2 = vvv.split("-");
               document.getElementById('year_from_2').value = myArray2[0];
               document.getElementById('year_to_2').value = myArray2[1];
            }
            if (v == 3) {

               const myArray = dataListArray[i].split("            ");
               document.getElementById('job_title_3').value = myArray[1];
               document.getElementById('company_name_3').value = myArray[0];
               var vvv = myArray[2];
               const myArray2 = vvv.split("-");
               document.getElementById('year_from_3').value = myArray2[0];
               document.getElementById('year_to_3').value = myArray2[1];
            }

            let newbtn = document.createElement("appendText");
            newbtn.innerHTML = v + '.' + dataListArray[i];
            i++;




            //newbtn.innerHTML = rowCount+'.    '+companyName+',       '+jobTitle+'       '+yearFrom+'-'+yearTo;

            var br = document.createElement("br");
            // the remove button
            let xspan = document.createElement('span');
            xspan.innerHTML = '<a href="javascript:FunctionCall();" style="display:inline-flex;"><img src="logos/cross-white.png" alt="cross icon"></a>'; //this gives it superscript text
            xspan.id = 'close'; //this was not necessary but it is nice to have
            xspan.onclick = function() {
               var value = newbtn.innerHTML;
               const streetAddress = value.substring(2, value.indexOf("<span id"));
               getValue = 1;
               newbtn.remove();
               rowCount = 0;
               br.remove();
               let index = dataListArray.indexOf(streetAddress);


               dataListArray.splice(index, 1);
               document.getElementById("myDIV").innerHTML = '';

               var k = 0;
               while (k < dataListArray.length) {

                  k = k + 1;
               }
               takeValues();




            };
            newbtn.appendChild(xspan);


            document.getElementById("myDIV").appendChild(newbtn);
            //   document.getElementById("myDIV").appendChild(br);

         }


         document.getElementById('addRow').style.display = 'none';
         document.getElementById('buttonAddRec').style.visibility = 'hidden';
         document.getElementById('addExpButton').style.visibility = 'visible';
         document.getElementById('job_title1').value = "";
         document.getElementById('company_name1').value = "";
         document.getElementById('year_from1').value = "";
         document.getElementById('year_to1').value = "";
         getValue = 0;
      }
   </script>
</body>

</html>